/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.graal.code.CGlobalDataInfo;
import com.oracle.svm.core.graal.nodes.CGlobalDataLoadAddressNode;
import com.oracle.svm.hosted.code.CCallStubMethod;
import com.oracle.svm.hosted.code.CFunctionFeature;
import com.oracle.svm.hosted.phases.HostedGraphKit;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.function.CFunction;

public final class CFunctionCallStubMethod
extends CCallStubMethod {
    private final CGlobalDataInfo linkage;

    CFunctionCallStubMethod(ResolvedJavaMethod original, CGlobalDataInfo linkage, boolean needsTransition) {
        super(original, needsTransition);
        this.linkage = linkage;
    }

    @Override
    protected String getCorrespondingAnnotationName() {
        return CFunction.class.getSimpleName();
    }

    @Override
    public StructuredGraph buildGraph(DebugContext debug, ResolvedJavaMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        if (purpose == GraphProvider.Purpose.PREPARE_RUNTIME_COMPILATION && this.needsTransition) {
            ((CFunctionFeature)ImageSingletons.lookup(CFunctionFeature.class)).warnRuntimeCompilationReachableCFunctionWithTransition(this);
            return null;
        }
        return super.buildGraph(debug, method, providers, purpose);
    }

    @Override
    protected ValueNode createTargetAddressNode(HostedGraphKit kit, HostedProviders providers) {
        return kit.unique(new CGlobalDataLoadAddressNode(this.linkage));
    }
}

