/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.code.AnalysisMethodCalleeWalker;
import com.oracle.svm.hosted.meta.HostedMethod;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.nodes.Invoke;

public class RestrictHeapAccessCallees {
    private Map<AnalysisMethod, RestrictionInfo> calleeToCallerMap = Collections.emptyMap();
    private List<ResolvedJavaMethod> assertionErrorConstructorList = Collections.emptyList();
    private boolean initialized = false;

    public void setAssertionErrorConstructors(List<ResolvedJavaMethod> resolvedConstructorList) {
        if (this.assertionErrorConstructorList.isEmpty()) {
            this.assertionErrorConstructorList = resolvedConstructorList;
        }
    }

    public RestrictionInfo getRestrictionInfo(ResolvedJavaMethod method) {
        return this.calleeToCallerMap.get(RestrictHeapAccessCallees.methodToKey(method));
    }

    public boolean mustNotAllocate(ResolvedJavaMethod method) {
        RestrictionInfo info = this.getRestrictionInfo(method);
        return info != null && (info.getAccess() == RestrictHeapAccess.Access.NO_ALLOCATION || info.getAccess().isMoreRestrictiveThan(RestrictHeapAccess.Access.NO_ALLOCATION));
    }

    public Map<AnalysisMethod, RestrictionInfo> getCallerMap() {
        return this.calleeToCallerMap;
    }

    public void aggregateMethods(Collection<AnalysisMethod> methods) {
        assert (!this.initialized) : "RestrictHeapAccessCallees.aggregateMethods: Should only initialize once.";
        HashMap<AnalysisMethod, RestrictionInfo> aggregation = new HashMap<AnalysisMethod, RestrictionInfo>();
        MethodAggregator visitor = new MethodAggregator(aggregation, this.assertionErrorConstructorList);
        AnalysisMethodCalleeWalker walker = new AnalysisMethodCalleeWalker();
        for (AnalysisMethod method : methods) {
            RestrictHeapAccess annotation = (RestrictHeapAccess)method.getAnnotation(RestrictHeapAccess.class);
            if ((annotation == null || annotation.access() == RestrictHeapAccess.Access.UNRESTRICTED) && !method.isAnnotationPresent(Uninterruptible.class)) continue;
            for (AnalysisMethod calleeImpl : method.getImplementations()) {
                walker.walkMethod(calleeImpl, visitor);
            }
        }
        this.calleeToCallerMap = Collections.unmodifiableMap(aggregation);
        this.initialized = true;
    }

    private static AnalysisMethod methodToKey(ResolvedJavaMethod method) {
        AnalysisMethod result;
        if (method instanceof AnalysisMethod) {
            result = (AnalysisMethod)method;
        } else if (method instanceof HostedMethod) {
            result = ((HostedMethod)method).getWrapped();
        } else {
            throw VMError.shouldNotReachHere("RestrictHeapAccessCallees.methodToKey: ResolvedJavaMethod is neither an AnalysisMethod nor a HostedMethod: " + method);
        }
        return result;
    }

    public static class RestrictionInfo {
        private final RestrictHeapAccess.Access access;
        private final AnalysisMethod caller;
        private final StackTraceElement invocationStackTraceElement;
        private final AnalysisMethod method;

        RestrictionInfo(RestrictHeapAccess.Access access, AnalysisMethod caller, StackTraceElement stackTraceElement, AnalysisMethod method) {
            this.access = access;
            this.caller = caller;
            this.invocationStackTraceElement = stackTraceElement;
            this.method = method;
        }

        public RestrictHeapAccess.Access getAccess() {
            return this.access;
        }

        public AnalysisMethod getCaller() {
            return this.caller;
        }

        public StackTraceElement getInvocationStackTraceElement() {
            return this.invocationStackTraceElement;
        }

        public AnalysisMethod getMethod() {
            return this.method;
        }
    }

    static class MethodAggregator
    extends AnalysisMethodCalleeWalker.CallPathVisitor {
        private final Map<AnalysisMethod, RestrictionInfo> calleeToCallerMap;
        private final List<ResolvedJavaMethod> assertionErrorConstructorList;

        MethodAggregator(Map<AnalysisMethod, RestrictionInfo> calleeToCallerMap, List<ResolvedJavaMethod> assertionErrorConstructorList) {
            this.calleeToCallerMap = calleeToCallerMap;
            this.assertionErrorConstructorList = assertionErrorConstructorList;
        }

        @Override
        public AnalysisMethodCalleeWalker.CallPathVisitor.VisitResult visitMethod(AnalysisMethod callee, AnalysisMethod caller, Invoke invoke, int depth) {
            RestrictHeapAccess annotation;
            RestrictHeapAccess.Access access = RestrictHeapAccess.Access.UNRESTRICTED;
            boolean overridesCallers = false;
            if (callee.isAnnotationPresent(Uninterruptible.class)) {
                access = RestrictHeapAccess.Access.NO_ALLOCATION;
            }
            if ((annotation = (RestrictHeapAccess)callee.getAnnotation(RestrictHeapAccess.class)) != null) {
                access = annotation.access();
                overridesCallers = annotation.overridesCallers();
            }
            if (overridesCallers || caller == null) {
                if (access == RestrictHeapAccess.Access.UNRESTRICTED) {
                    return AnalysisMethodCalleeWalker.CallPathVisitor.VisitResult.CUT;
                }
            } else {
                RestrictHeapAccess.Access callerAccess = this.calleeToCallerMap.get(caller).getAccess();
                if (callerAccess.isMoreRestrictiveThan(access)) {
                    access = callerAccess;
                }
            }
            if (access == RestrictHeapAccess.Access.NO_ALLOCATION && this.assertionErrorConstructorList != null && this.assertionErrorConstructorList.contains(callee)) {
                return AnalysisMethodCalleeWalker.CallPathVisitor.VisitResult.CUT;
            }
            RestrictionInfo restrictionInfo = this.calleeToCallerMap.get(callee);
            if (restrictionInfo != null && !access.isMoreRestrictiveThan(restrictionInfo.getAccess())) {
                return AnalysisMethodCalleeWalker.CallPathVisitor.VisitResult.CUT;
            }
            StackTraceElement callerStackTraceElement = caller != null ? caller.asStackTraceElement(invoke.bci()) : null;
            restrictionInfo = new RestrictionInfo(access, caller, callerStackTraceElement, callee);
            this.calleeToCallerMap.put(callee, restrictionInfo);
            return AnalysisMethodCalleeWalker.CallPathVisitor.VisitResult.CONTINUE;
        }
    }
}

