/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge.graal;

import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.CardTable;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.genscavenge.graal.BarrierSnippetCounters;
import com.oracle.svm.core.genscavenge.graal.PostWriteBarrierNode;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.option.HostedOptionKey;
import java.util.Map;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.extended.FixedValueAnchorNode;
import org.graalvm.compiler.nodes.memory.address.OffsetAddressNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.UnsignedWord;

public class BarrierSnippets
extends SubstrateTemplates
implements Snippets {
    @Fold
    protected static BarrierSnippetCounters counters() {
        return (BarrierSnippetCounters)ImageSingletons.lookup(BarrierSnippetCounters.class);
    }

    protected static BarrierSnippets factory(OptionValues options, Iterable<DebugHandlersFactory> factories, Providers providers, SnippetReflectionProvider snippetReflection) {
        return new BarrierSnippets(options, factories, providers, snippetReflection);
    }

    public void registerLowerings(Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        lowerings.put(PostWriteBarrierNode.class, new PostWriteBarrierLowering());
    }

    @Snippet
    public static void postWriteBarrierSnippet(Object object) {
        BarrierSnippets.counters().postWriteBarrier.inc();
        Object fixedObject = FixedValueAnchorNode.getObject((Object)object);
        UnsignedWord objectHeader = ObjectHeader.readHeaderFromObject(fixedObject);
        boolean needsBarrier = ObjectHeaderImpl.hasRememberedSet(objectHeader);
        if (BranchProbabilityNode.probability((double)0.9, (!needsBarrier ? 1 : 0) != 0)) {
            return;
        }
        boolean unaligned = ObjectHeaderImpl.isHeapObjectUnaligned(objectHeader);
        if (BranchProbabilityNode.probability((double)0.6, (!unaligned ? 1 : 0) != 0)) {
            BarrierSnippets.counters().postWriteBarrierAligned.inc();
            AlignedHeapChunk.dirtyCardForObjectOfAlignedHeapChunk(fixedObject);
            return;
        }
        BarrierSnippets.counters().postWriteBarrierUnaligned.inc();
        UnalignedHeapChunk.dirtyCardForObjectOfUnalignedHeapChunk(fixedObject);
    }

    protected BarrierSnippets(OptionValues options, Iterable<DebugHandlersFactory> factories, Providers providers, SnippetReflectionProvider snippetReflection) {
        super(options, factories, providers, snippetReflection);
    }

    public static final class TestingBackDoor {
        private TestingBackDoor() {
        }

        public static long getPostWriteBarrierCount() {
            return BarrierSnippets.counters().postWriteBarrier.getValue();
        }

        public static long getPostWriteBarrierAlignedCount() {
            return BarrierSnippets.counters().postWriteBarrierAligned.getValue();
        }

        public static long getPostWriteBarrierUnalignedCount() {
            return BarrierSnippets.counters().postWriteBarrierUnaligned.getValue();
        }
    }

    protected class PostWriteBarrierLowering
    implements NodeLoweringProvider<PostWriteBarrierNode> {
        private final SnippetTemplate.SnippetInfo postWriteBarrierSnippetInfo;

        protected PostWriteBarrierLowering() {
            this.postWriteBarrierSnippetInfo = BarrierSnippets.this.snippet(BarrierSnippets.class, "postWriteBarrierSnippet", new LocationIdentity[]{CardTable.CARD_REMEMBERED_SET_LOCATION});
        }

        @Override
        public void lower(PostWriteBarrierNode barrier, LoweringTool tool) {
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.postWriteBarrierSnippetInfo, barrier.graph().getGuardsStage(), tool.getLoweringStage());
            OffsetAddressNode address = (OffsetAddressNode)barrier.getAddress();
            args.add("object", (Object)address.getBase());
            BarrierSnippets.this.template((ValueNode)barrier, args).instantiate(BarrierSnippets.this.providers.getMetaAccess(), (FixedNode)barrier, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }

    public static class Options {
        @Option(help={"Instrument write barriers with counters"})
        public static final HostedOptionKey<Boolean> CountWriteBarriers = new HostedOptionKey<Boolean>(false);
    }
}

