/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.jdk.Resources;
import com.oracle.svm.core.jdk.URLProtocolsSupport;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.VMError;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Arrays;
import java.util.List;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class JavaNetSubstitutions {
    public static final String FILE_PROTOCOL = "file";
    public static final String RESOURCE_PROTOCOL = "resource";
    public static final String HTTP_PROTOCOL = "http";
    public static final String HTTPS_PROTOCOL = "https";
    static final List<String> defaultProtocols = Arrays.asList("file", "resource");
    static final List<String> onDemandProtocols = Arrays.asList("http", "https");
    static final String enableProtocolsOption = SubstrateOptionsParser.commandArgument(SubstrateOptions.EnableURLProtocols, "");

    @Platforms(value={Platform.HOSTED_ONLY.class})
    static boolean addURLStreamHandler(String protocol) {
        if (RESOURCE_PROTOCOL.equals(protocol)) {
            URLStreamHandler resourcesURLStreamHandler = JavaNetSubstitutions.createResourcesURLStreamHandler();
            URLProtocolsSupport.put(RESOURCE_PROTOCOL, resourcesURLStreamHandler);
            return true;
        }
        try {
            Method method = URL.class.getDeclaredMethod("getURLStreamHandler", String.class);
            method.setAccessible(true);
            URLStreamHandler handler = (URLStreamHandler)method.invoke(null, protocol);
            if (handler != null) {
                URLProtocolsSupport.put(protocol, handler);
                return true;
            }
            return false;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new Error(ex);
        }
    }

    static URLStreamHandler getURLStreamHandler(String protocol) {
        URLStreamHandler result = URLProtocolsSupport.get(protocol);
        if (result == null) {
            if (onDemandProtocols.contains(protocol)) {
                JavaNetSubstitutions.unsupported("Accessing an URL protocol that was not enabled. The URL protocol " + protocol + " is supported but not enabled by default. It must be enabled by adding the " + enableProtocolsOption + protocol + " option to the native-image command.");
            } else {
                JavaNetSubstitutions.unsupported("Accessing an URL protocol that was not enabled. The URL protocol " + protocol + " is not tested and might not work as expected. It can be enabled by adding the " + enableProtocolsOption + protocol + " option to the native-image command.");
            }
        }
        return result;
    }

    static URLStreamHandler createResourcesURLStreamHandler() {
        return new URLStreamHandler(){

            @Override
            protected URLConnection openConnection(URL url) throws IOException {
                return new URLConnection(url){

                    @Override
                    public void connect() throws IOException {
                    }

                    @Override
                    public InputStream getInputStream() throws IOException {
                        Resources.ResourcesSupport support = (Resources.ResourcesSupport)ImageSingletons.lookup(Resources.ResourcesSupport.class);
                        String resName = this.url.toString().substring(1 + JavaNetSubstitutions.RESOURCE_PROTOCOL.length());
                        List<byte[]> bytes = support.resources.get(resName);
                        if (bytes == null || bytes.size() < 1) {
                            return null;
                        }
                        return new ByteArrayInputStream(bytes.get(0));
                    }
                };
            }
        };
    }

    private static void unsupported(String message) {
        throw VMError.unsupportedFeature(message);
    }

    static String supportedProtocols() {
        return "Supported URL protocols enabled by default: " + String.join((CharSequence)",", defaultProtocols) + ". Supported URL protocols available on demand: " + String.join((CharSequence)",", onDemandProtocols) + ".";
    }
}

