/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.config;

import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.OptionUtils;
import com.oracle.svm.hosted.ImageClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionType;

public final class ConfigurationDirectories {
    static List<String> findConfigurationFiles(String fileName) {
        ArrayList<String> files = new ArrayList<String>();
        for (String directory : OptionUtils.flatten(",", Options.ConfigurationFileDirectories.getValue())) {
            Path path = Paths.get(directory, fileName);
            if (!Files.exists(path, new LinkOption[0])) continue;
            files.add(path.toString());
        }
        return files;
    }

    static List<String> findConfigurationResources(String fileName, ImageClassLoader classLoader) {
        ArrayList<String> resources = new ArrayList<String>();
        for (String root : OptionUtils.flatten(",", Options.ConfigurationResourceRoots.getValue())) {
            String separator = "/";
            String relativeRoot = Stream.of(root.split("/")).filter(part -> !part.isEmpty() && !part.equals(".")).collect(Collectors.joining("/"));
            String relativePath = relativeRoot.isEmpty() ? fileName : relativeRoot + '/' + fileName;
            if (classLoader.findResourceByName(relativePath) == null) continue;
            resources.add(relativePath);
        }
        return resources;
    }

    public static final class Options {
        @Option(help={"Directories directly containing configuration files for dynamic features at runtime."}, type=OptionType.User)
        static final HostedOptionKey<String[]> ConfigurationFileDirectories = new HostedOptionKey<Object>(null);
        @Option(help={"Resource path above configuration resources for dynamic features at runtime."}, type=OptionType.User)
        public static final HostedOptionKey<String[]> ConfigurationResourceRoots = new HostedOptionKey<Object>(null);
    }

    public static final class FileNames {
        private static final String SUFFIX = "-config.json";
        public static final String DYNAMIC_PROXY_NAME = "proxy-config.json";
        public static final String RESOURCES_NAME = "resource-config.json";
        public static final String JNI_NAME = "jni-config.json";
        public static final String REFLECTION_NAME = "reflect-config.json";
    }
}

