/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.config;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.OptionUtils;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.json.JSONParserException;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.config.ConfigurationDirectories;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public abstract class ConfigurationParser {
    public static void parseAndRegisterConfigurations(ConfigurationParser parser, ImageClassLoader classLoader, String featureName, HostedOptionKey<String[]> configFilesOption, HostedOptionKey<String[]> configResourcesOption, String directoryFileName) {
        Stream files = Stream.concat(OptionUtils.flatten(",", configFilesOption.getValue()).stream(), ConfigurationDirectories.findConfigurationFiles(directoryFileName).stream());
        files.forEach(path -> {
            File file = new File((String)path).getAbsoluteFile();
            if (!file.exists()) {
                throw UserError.abort("The " + featureName + " configuration file \"" + file + "\" does not exist.");
            }
            try (FileReader reader = new FileReader(file);){
                ConfigurationParser.doParseAndRegister(parser, reader, featureName, file, configFilesOption);
            }
            catch (IOException e) {
                throw UserError.abort("Could not open " + file + ": " + e.getMessage());
            }
        });
        Stream resources = Stream.concat(OptionUtils.flatten(",", configResourcesOption.getValue()).stream(), ConfigurationDirectories.findConfigurationResources(directoryFileName, classLoader).stream());
        resources.forEach(resource -> {
            URL url = classLoader.findResourceByName((String)resource);
            if (url == null) {
                throw UserError.abort("Could not find " + featureName + " configuration resource \"" + resource + "\".");
            }
            try (InputStreamReader reader = new InputStreamReader(url.openStream());){
                ConfigurationParser.doParseAndRegister(parser, reader, featureName, url, configResourcesOption);
            }
            catch (IOException e) {
                throw UserError.abort("Could not open " + url + ": " + e.getMessage());
            }
        });
    }

    private static void doParseAndRegister(ConfigurationParser parser, Reader reader, String featureName, Object location, HostedOptionKey<String[]> option) {
        try {
            parser.parseAndRegister(reader);
        }
        catch (JSONParserException | IOException e) {
            String errorMessage = e.getMessage();
            if (errorMessage == null || errorMessage.isEmpty()) {
                errorMessage = e.toString();
            }
            throw UserError.abort("Error parsing " + featureName + " configuration in " + location + ":\n" + errorMessage + "\nVerify that the configuration matches the schema described in the " + SubstrateOptionsParser.commandArgument(SubstrateOptions.PrintFlags, "+") + " output for option " + option.getName() + ".");
        }
    }

    public abstract void parseAndRegister(Reader var1) throws IOException;

    static List<Object> asList(Object data, String errorMessage) {
        if (data instanceof List) {
            return (List)data;
        }
        throw new JSONParserException(errorMessage);
    }

    static Map<String, Object> asMap(Object data, String errorMessage) {
        if (data instanceof Map) {
            return (Map)data;
        }
        throw new JSONParserException(errorMessage);
    }

    static String asString(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        throw new JSONParserException("Invalid string value \"" + value + "\".");
    }

    static String asString(Object value, String propertyName) {
        if (value instanceof String) {
            return (String)value;
        }
        throw new JSONParserException("Invalid string value \"" + value + "\" for element '" + propertyName + "'");
    }

    static boolean asBoolean(Object value, String propertyName) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new JSONParserException("Invalid boolean value '" + value + "' for element '" + propertyName + "'");
    }
}

