/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.server;

import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ImageBuildTask;
import com.oracle.svm.hosted.NativeImageClassLoader;
import com.oracle.svm.hosted.NativeImageGeneratorRunner;
import com.oracle.svm.hosted.server.NativeImageThreadFactory;
import com.oracle.svm.hosted.server.StreamingServerMessageOutputStream;
import com.oracle.svm.hosted.server.SubstrateServerMessage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.logging.LogManager;
import java.util.stream.Collectors;
import org.graalvm.collections.EconomicSet;

public final class NativeImageBuildServer {
    public static final String PORT_LOG_MESSAGE_PREFIX = "Started image build server on port: ";
    public static final String TASK_PREFIX = "-task=";
    public static final String PORT_PREFIX = "-port=";
    public static final String LOG_PREFIX = "-logFile=";
    private static final int TIMEOUT_MINUTES = 240;
    private static final String GRAALVM_VERSION_PROPERTY = "org.graalvm.version";
    private static final int SERVER_THREAD_POOL_SIZE = 4;
    private static final int FAILED_EXIT_STATUS = -1;
    private static Set<ImageBuildTask> tasks = Collections.synchronizedSet(new HashSet());
    private boolean terminated;
    private final int port;
    private PrintStream logOutput;
    private final StreamingServerMessageOutputStream outJSONStream = new StreamingServerMessageOutputStream(SubstrateServerMessage.ServerCommand.WRITE_OUT, null);
    private final StreamingServerMessageOutputStream errorJSONStream = new StreamingServerMessageOutputStream(SubstrateServerMessage.ServerCommand.WRITE_ERR, null);
    private final PrintStream serverStdout = new PrintStream(this.outJSONStream, true);
    private final PrintStream serverStderr = new PrintStream(this.errorJSONStream, true);
    private final AtomicLong activeBuildTasks = new AtomicLong();
    private Instant lastKeepAliveAction = Instant.now();
    private ThreadPoolExecutor threadPoolExecutor;

    private NativeImageBuildServer(int port, PrintStream logOutput) {
        this.port = port;
        this.logOutput = logOutput;
        this.threadPoolExecutor = new ThreadPoolExecutor(4, 4, Long.MAX_VALUE, TimeUnit.DAYS, new LinkedBlockingQueue<Runnable>());
        NativeImageBuildServer.withGlobalStaticField("java.lang.UNIXProcess", "processReaperExecutor", f -> {
            ThreadPoolExecutor executor = (ThreadPoolExecutor)f.get(null);
            ThreadFactory factory = executor.getThreadFactory();
            executor.setThreadFactory(r -> {
                Thread t = factory.newThread(r);
                t.setContextClassLoader(NativeImageBuildServer.class.getClassLoader());
                return t;
            });
        });
        System.setProperty("java.util.concurrent.ForkJoinPool.common.threadFactory", NativeImageThreadFactory.class.getName());
        if (ForkJoinPool.commonPool().getFactory().getClass() != NativeImageThreadFactory.class) {
            throw VMError.shouldNotReachHere("Wrong thread pool factory: " + ForkJoinPool.commonPool().getFactory().getClass());
        }
    }

    private void log(String commandLine, Object ... args) {
        this.logOutput.printf(commandLine, args);
        this.logOutput.flush();
    }

    private static void printUsageAndExit() {
        System.out.println("Usage:");
        System.out.println(String.format("  java -cp <compiler_class_path> " + NativeImageBuildServer.class.getName() + " %s<port_number> %s<log_file>", PORT_PREFIX, LOG_PREFIX));
        System.exit(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argsArray) {
        Optional<Integer> port;
        ArrayList<String> args;
        if (!NativeImageGeneratorRunner.verifyValidJavaVersionAndPlatform()) {
            System.exit(-1);
        }
        if ((args = new ArrayList<String>(Arrays.asList(argsArray))).size() < 1) {
            NativeImageBuildServer.printUsageAndExit();
        }
        if (!(port = NativeImageBuildServer.extractPort(args)).isPresent()) {
            NativeImageBuildServer.printUsageAndExit();
        } else {
            Optional<String> logFile = NativeImageBuildServer.extractLogFile(args);
            PrintStream output = System.out;
            try {
                if (logFile.isPresent()) {
                    File file = new File(logFile.get());
                    if (!file.createNewFile()) {
                        System.err.println("The log file already exists, or could not be created.");
                        System.exit(-1);
                    }
                    output = new PrintStream(new FileOutputStream(file));
                }
                new NativeImageBuildServer(port.get(), output).serve();
            }
            catch (IOException e) {
                System.err.println("Starting server failed with an exception: " + e);
                System.exit(-1);
            }
            finally {
                if (logFile.isPresent()) {
                    output.flush();
                    output.close();
                }
            }
        }
    }

    private static Optional<String> extractLogFile(List<String> args) {
        Optional<String> portArg = NativeImageBuildServer.extractArg(args, LOG_PREFIX);
        return portArg.map(arg -> arg.substring(LOG_PREFIX.length()));
    }

    static Optional<Integer> extractPort(List<String> args) {
        Optional<String> portArg = NativeImageBuildServer.extractArg(args, PORT_PREFIX);
        try {
            return portArg.map(arg -> Integer.parseInt(arg.substring(PORT_PREFIX.length())));
        }
        catch (Throwable ignored) {
            System.err.println("error: invalid port number format");
            return Optional.empty();
        }
    }

    static Optional<String> extractArg(List<String> args, String argPrefix) {
        Optional<String> portArg = args.stream().filter(x -> x.startsWith(argPrefix)).reduce((first, second) -> second);
        args.removeIf(a -> a.startsWith(argPrefix));
        return portArg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void serve() {
        this.threadPoolExecutor.purge();
        if (this.port == 0) {
            this.log("Server selects ephemeral port\n", new Object[0]);
        } else {
            this.log("Try binding server to port " + this.port + "...\n", new Object[0]);
        }
        try {
            ServerSocket serverSocket = new ServerSocket();
            Throwable throwable = null;
            try {
                try {
                    serverSocket.setReuseAddress(true);
                    serverSocket.setSoTimeout((int)TimeUnit.MINUTES.toMillis(240L));
                    serverSocket.bind(new InetSocketAddress(InetAddress.getLoopbackAddress(), this.port));
                    String portLogMessage = PORT_LOG_MESSAGE_PREFIX + serverSocket.getLocalPort();
                    System.out.println(portLogMessage);
                    System.out.flush();
                    this.log(portLogMessage, new Object[0]);
                    while (true) {
                        Socket socket = serverSocket.accept();
                        this.log("Accepted request from " + socket.getInetAddress().getHostName() + ". Queuing to position: " + this.threadPoolExecutor.getQueue().size() + "\n", new Object[0]);
                        this.threadPoolExecutor.execute(() -> {
                            if (!this.processRequest(socket)) {
                                this.closeServerSocket(serverSocket);
                            }
                        });
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (serverSocket != null) {
                    if (throwable != null) {
                        try {
                            serverSocket.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        serverSocket.close();
                    }
                }
                throw throwable3;
            }
        }
        catch (SocketTimeoutException ste) {
            this.log("Compilation server timed out. Shutting down...\n", new Object[0]);
            this.log("Shutting down server...\n", new Object[0]);
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.threadPoolExecutor.shutdownNow();
        }
        catch (SocketException se) {
            this.log("Terminated: " + se.getMessage() + "\n", new Object[0]);
            if (!this.terminated) {
                this.log("Server error: " + se.getMessage() + "\n", new Object[0]);
            }
        }
        catch (IOException e) {
            this.log("IOException in the socket operation.", e);
            this.log("Shutting down server...\n", new Object[0]);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
            }
            this.threadPoolExecutor.shutdownNow();
        }
        {
            finally {
                this.log("Shutting down server...\n", new Object[0]);
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.threadPoolExecutor.shutdownNow();
            }
        }
    }

    private void closeServerSocket(ServerSocket serverSocket) {
        try {
            this.log("Terminating...", new Object[0]);
            this.terminated = true;
            serverSocket.close();
        }
        catch (IOException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processRequest(Socket socket) {
        block8: {
            try {
                DataOutputStream output = new DataOutputStream(socket.getOutputStream());
                DataInputStream input = new DataInputStream(socket.getInputStream());
                try {
                    boolean bl = this.processCommand(socket, SubstrateServerMessage.receive(input));
                    return bl;
                }
                catch (Throwable t) {
                    try {
                        this.log("Execution failed: " + t + "\n", new Object[0]);
                        t.printStackTrace(this.logOutput);
                        NativeImageBuildServer.sendExitStatus(output, 1);
                    }
                    catch (IOException ioe) {
                        this.log("Failed fetching the output stream.", new Object[0]);
                        break block8;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    NativeImageBuildServer.closeConnection(socket);
                    this.log("Connection with the client closed.\n", new Object[0]);
                    System.gc();
                    System.runFinalization();
                    System.gc();
                    this.log("Available Memory: " + Runtime.getRuntime().freeMemory() + "\n", new Object[0]);
                }
            }
            finally {
                NativeImageBuildServer.closeConnection(socket);
                this.log("Connection with the client closed.\n", new Object[0]);
                System.gc();
                System.runFinalization();
                System.gc();
                this.log("Available Memory: " + Runtime.getRuntime().freeMemory() + "\n", new Object[0]);
            }
        }
        return true;
    }

    private static void closeConnection(Socket socket) {
        try {
            socket.close();
        }
        catch (IOException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processCommand(Socket socket, SubstrateServerMessage serverCommand) throws IOException {
        DataOutputStream output = new DataOutputStream(socket.getOutputStream());
        switch (serverCommand.command) {
            case STOP_SERVER: {
                this.log("Received 'stop' request. Shutting down server.\n", new Object[0]);
                NativeImageBuildServer.sendExitStatus(output, 0);
                return false;
            }
            case GET_VERSION: {
                this.log("Received 'version' request. Responding with " + System.getProperty(GRAALVM_VERSION_PROPERTY) + ".\n", new Object[0]);
                SubstrateServerMessage.send(new SubstrateServerMessage(serverCommand.command, System.getProperty(GRAALVM_VERSION_PROPERTY).getBytes()), output);
                return Instant.now().isBefore(this.lastKeepAliveAction.plus(Duration.ofMinutes(240L)));
            }
            case BUILD_IMAGE: {
                try {
                    long activeTasks = this.activeBuildTasks.incrementAndGet();
                    if (activeTasks > 1L) {
                        String message = "Can not build image: tasks are already running in the server.\n";
                        this.log(message, new Object[0]);
                        NativeImageBuildServer.sendError(output, message);
                        NativeImageBuildServer.sendExitStatus(output, -1);
                    } else {
                        this.log("Starting compilation for request:\n%s\n", serverCommand.payloadString());
                        ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(serverCommand.payloadString().split("\n")));
                        this.errorJSONStream.writingInterrupted(false);
                        this.errorJSONStream.setOriginal(socket.getOutputStream());
                        this.outJSONStream.writingInterrupted(false);
                        this.outJSONStream.setOriginal(socket.getOutputStream());
                        int exitStatus = NativeImageBuildServer.withJVMContext(this.serverStdout, this.serverStderr, () -> NativeImageBuildServer.executeCompilation(arguments));
                        NativeImageBuildServer.sendExitStatus(output, exitStatus);
                        this.log("Image building completed.\n", new Object[0]);
                        this.lastKeepAliveAction = Instant.now();
                    }
                }
                finally {
                    this.activeBuildTasks.decrementAndGet();
                }
                return true;
            }
            case ABORT_BUILD: {
                this.log("Received 'abort' request. Interrupting all image build tasks.\n", new Object[0]);
                this.errorJSONStream.writingInterrupted(true);
                this.outJSONStream.writingInterrupted(true);
                while (this.errorJSONStream.isWriting() || this.outJSONStream.isWriting()) {
                }
                this.outJSONStream.flush();
                this.errorJSONStream.flush();
                for (ImageBuildTask task : tasks) {
                    this.threadPoolExecutor.submit(task::interruptBuild);
                }
                NativeImageBuildServer.sendExitStatus(output, 0);
                return true;
            }
        }
        this.log("Invalid command: " + (Object)((Object)serverCommand.command), new Object[0]);
        NativeImageBuildServer.sendExitStatus(output, 1);
        return true;
    }

    private static void sendExitStatus(DataOutputStream output, int exitStatus) {
        try {
            SubstrateServerMessage.send(new SubstrateServerMessage(SubstrateServerMessage.ServerCommand.SEND_STATUS, ByteBuffer.allocate(4).putInt(exitStatus).array()), output);
        }
        catch (IOException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    private static void sendError(DataOutputStream output, String message) {
        try {
            SubstrateServerMessage.send(new SubstrateServerMessage(SubstrateServerMessage.ServerCommand.WRITE_ERR, message.getBytes()), output);
        }
        catch (IOException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Integer executeCompilation(ArrayList<String> arguments) {
        String[] classpath = NativeImageGeneratorRunner.extractImageClassPath(arguments);
        ClassLoader applicationClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Integer n;
            NativeImageClassLoader imageClassLoader = NativeImageGeneratorRunner.installNativeImageClassLoader(classpath);
            ImageBuildTask task = NativeImageBuildServer.loadCompilationTask(arguments, imageClassLoader);
            try {
                tasks.add(task);
                n = task.build(arguments.toArray(new String[arguments.size()]), classpath, imageClassLoader);
                tasks.remove(task);
            }
            catch (Throwable throwable) {
                tasks.remove(task);
                throw throwable;
            }
            return n;
        }
        finally {
            Thread.currentThread().setContextClassLoader(applicationClassLoader);
        }
    }

    private static int withJVMContext(PrintStream out, PrintStream err, Supplier<Integer> body) {
        Properties previousProperties = (Properties)System.getProperties().clone();
        PrintStream previousOut = System.out;
        PrintStream previousErr = System.err;
        System.setOut(out);
        System.setErr(err);
        ResourceBundle.clearCache();
        try {
            int n = body.get();
            return n;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw t;
        }
        finally {
            System.setProperties(previousProperties);
            System.setOut(previousOut);
            System.setErr(previousErr);
            NativeImageBuildServer.resetGlobalStateInLoggers();
            NativeImageBuildServer.resetResourceBundle();
            NativeImageBuildServer.resetGlobalStateInGraal();
            NativeImageBuildServer.withGlobalStaticField("java.lang.ApplicationShutdownHooks", "hooks", f -> {
                IdentityHashMap hooks = (IdentityHashMap)f.get(null);
                hooks.forEach((x, y) -> {
                    x.setContextClassLoader(NativeImageBuildServer.class.getClassLoader());
                    y.setContextClassLoader(NativeImageBuildServer.class.getClassLoader());
                });
            });
        }
    }

    private static void resetGlobalStateInLoggers() {
        LogManager.getLogManager().reset();
        NativeImageBuildServer.withGlobalStaticField("java.util.logging.Level$KnownLevel", "nameToLevels", NativeImageBuildServer::removeImageLoggers);
        NativeImageBuildServer.withGlobalStaticField("java.util.logging.Level$KnownLevel", "intToLevels", NativeImageBuildServer::removeImageLoggers);
    }

    private static void removeImageLoggers(Field f) throws IllegalAccessException {
        HashMap newHashMap = new HashMap();
        HashMap currentNameToLevels = (HashMap)f.get(null);
        currentNameToLevels.entrySet().stream().filter(NativeImageBuildServer::isSystemLoaderLogLevelEntry).forEach(e -> newHashMap.put(e.getKey(), e.getValue()));
        f.set(null, newHashMap);
    }

    private static boolean isSystemLoaderLogLevelEntry(Map.Entry<?, ?> e) {
        return ((List)e.getValue()).stream().map(x -> NativeImageBuildServer.getFieldValueOfObject("java.util.logging.Level$KnownLevel", "levelObject", x)).allMatch(NativeImageBuildServer::isSystemClassLoader);
    }

    private static Object getFieldValueOfObject(String className, String fieldName, Object o) {
        try {
            Field field = Class.forName(className).getDeclaredField(fieldName);
            field.setAccessible(true);
            Object res = field.get(o);
            field.setAccessible(false);
            return res;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
            throw VMError.shouldNotReachHere("Static field " + fieldName + " of class " + className + " can't be reset. Underlying exception: " + e.getMessage());
        }
    }

    private static boolean isSystemClassLoader(Object obj) {
        return obj.getClass().getClassLoader() == null || obj.getClass().getClassLoader() == ClassLoader.getSystemClassLoader() || obj.getClass().getClassLoader() == ClassLoader.getSystemClassLoader().getParent();
    }

    private static void withGlobalStaticField(String className, String fieldName, FieldAction action) {
        try {
            Field field = Class.forName(className).getDeclaredField(fieldName);
            field.setAccessible(true);
            action.perform(field);
            field.setAccessible(false);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
            throw VMError.shouldNotReachHere("Static field " + fieldName + " of class " + className + " can't be reset. Underlying exception: " + e.getMessage());
        }
    }

    private static void resetGlobalStateInGraal() {
        NativeImageBuildServer.withGlobalStaticField("org.graalvm.compiler.nodes.NamedLocationIdentity$DB", "map", f -> ((EconomicSet)f.get(null)).clear());
        NativeImageBuildServer.withGlobalStaticField("org.graalvm.compiler.debug.DebugContext$Immutable", "CACHE", f -> {
            Object[] cache = (Object[])f.get(null);
            for (int i = 0; i < cache.length; ++i) {
                cache[i] = null;
            }
        });
    }

    private static void resetResourceBundle() {
        NativeImageBuildServer.withGlobalStaticField("java.util.ResourceBundle", "cacheList", list -> ((ConcurrentHashMap)list.get(null)).clear());
    }

    private static ImageBuildTask loadCompilationTask(ArrayList<String> arguments, ClassLoader classLoader) {
        Optional<String> taskParameter = arguments.stream().filter(arg -> arg.startsWith(TASK_PREFIX)).findFirst();
        if (!taskParameter.isPresent()) {
            throw UserError.abort("image building task not specified. Provide the fully qualified task name after the \"-task=\" argument.");
        }
        arguments.removeAll(arguments.stream().filter(arg -> arg.startsWith(TASK_PREFIX)).collect(Collectors.toList()));
        String task = taskParameter.get().substring(TASK_PREFIX.length());
        try {
            Class<?> imageTaskClass = Class.forName(task, true, classLoader);
            return (ImageBuildTask)imageTaskClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw UserError.abort("image building task " + task + " can not be found. Make sure that " + task + " is present on the classpath.");
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw UserError.abort("image building task " + task + " must have a public constructor without parameters.");
        }
    }

    static interface FieldAction {
        public void perform(Field var1) throws IllegalAccessException;
    }
}

