/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.amd64;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.graal.amd64.SubstrateAMD64AddressLowering;
import com.oracle.svm.core.graal.code.SubstrateAddressLoweringPhaseFactory;
import com.oracle.svm.core.graal.meta.SubstrateRegisterConfig;
import org.graalvm.compiler.core.common.CompressEncoding;
import org.graalvm.compiler.phases.Phase;
import org.graalvm.compiler.phases.common.AddressLoweringPhase;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
class SubstrateAMD64AddressLoweringPhaseFeature
implements Feature {
    SubstrateAMD64AddressLoweringPhaseFeature() {
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return Platform.includedIn(Platform.AMD64.class) && SubstrateOptions.CompilerBackend.getValue().equals("lir");
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(SubstrateAddressLoweringPhaseFactory.class, (Object)new SubstrateAddressLoweringPhaseFactory(){

            @Override
            public Phase newAddressLowering(CompressEncoding compressEncoding, SubstrateRegisterConfig registerConfig) {
                SubstrateAMD64AddressLowering addressLowering = new SubstrateAMD64AddressLowering(compressEncoding, registerConfig);
                return new AddressLoweringPhase((AddressLoweringPhase.AddressLowering)addressLowering);
            }
        });
    }
}

