/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jdk.JDK8OrEarlier;
import com.oracle.svm.core.posix.Java_lang_Process_Supplement;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.Target_java_lang_ProcessBuilder_NullInputStream;
import com.oracle.svm.core.posix.Target_java_lang_ProcessBuilder_NullOutputStream;
import com.oracle.svm.core.posix.Target_java_lang_UNIXProcess_ProcessPipeInputStream;
import com.oracle.svm.core.posix.Target_java_lang_UNIXProcess_ProcessPipeOutputStream;
import com.oracle.svm.core.posix.headers.Signal;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Executor;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.impl.InternalPlatform;

@TargetClass(className="java.lang.UNIXProcess", onlyWith={JDK8OrEarlier.class})
@Platforms(value={InternalPlatform.LINUX_AND_JNI.class, InternalPlatform.DARWIN_AND_JNI.class})
final class Target_java_lang_UNIXProcess {
    @Platforms(value={Platform.LINUX.class, Platform.DARWIN.class})
    @Delete
    static Executor processReaperExecutor;
    @Alias
    int pid;
    @Alias
    OutputStream stdin;
    @Alias
    InputStream stdout;
    @Alias
    InputStream stderr;
    @Alias
    int exitcode;
    @Alias
    boolean hasExited;

    Target_java_lang_UNIXProcess() {
    }

    @Substitute
    @Platforms(value={Platform.LINUX.class, Platform.DARWIN.class})
    int forkAndExec(int mode, byte[] helperpath, byte[] file, byte[] argBlock, int argCount, byte[] envBlock, int envCount, byte[] dir, int[] fds, boolean redirectErrorStream) throws IOException {
        return Java_lang_Process_Supplement.forkAndExec(mode, helperpath, file, argBlock, argCount, envBlock, envCount, dir, fds, redirectErrorStream);
    }

    @Substitute
    @Platforms(value={Platform.LINUX.class, Platform.DARWIN.class})
    void initStreams(int[] fds) {
        Object in = Target_java_lang_ProcessBuilder_NullOutputStream.INSTANCE;
        if (fds[0] != -1) {
            in = new Target_java_lang_UNIXProcess_ProcessPipeOutputStream(fds[0]);
        }
        this.stdin = KnownIntrinsics.unsafeCast(in, OutputStream.class);
        Object out = Target_java_lang_ProcessBuilder_NullInputStream.INSTANCE;
        if (fds[1] != -1) {
            out = new Target_java_lang_UNIXProcess_ProcessPipeInputStream(fds[1]);
        }
        this.stdout = KnownIntrinsics.unsafeCast(out, InputStream.class);
        Object err = Target_java_lang_ProcessBuilder_NullInputStream.INSTANCE;
        if (fds[2] != -1) {
            err = new Target_java_lang_UNIXProcess_ProcessPipeInputStream(fds[2]);
        }
        this.stderr = KnownIntrinsics.unsafeCast(err, InputStream.class);
        Thread reaperThread = Java_lang_Process_Supplement.reaperFactory.newThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int status = Target_java_lang_UNIXProcess.this.waitForProcessExit(Target_java_lang_UNIXProcess.this.pid);
                Target_java_lang_UNIXProcess target_java_lang_UNIXProcess = Target_java_lang_UNIXProcess.this;
                synchronized (target_java_lang_UNIXProcess) {
                    Target_java_lang_UNIXProcess.this.exitcode = status;
                    Target_java_lang_UNIXProcess.this.hasExited = true;
                    Target_java_lang_UNIXProcess.this.notifyAll();
                }
                if (Target_java_lang_UNIXProcess.this.stdout != Target_java_lang_ProcessBuilder_NullInputStream.INSTANCE) {
                    KnownIntrinsics.unsafeCast(Target_java_lang_UNIXProcess.this.stdout, Target_java_lang_UNIXProcess_ProcessPipeInputStream.class).processExited();
                }
                if (Target_java_lang_UNIXProcess.this.stderr != Target_java_lang_ProcessBuilder_NullInputStream.INSTANCE) {
                    KnownIntrinsics.unsafeCast(Target_java_lang_UNIXProcess.this.stderr, Target_java_lang_UNIXProcess_ProcessPipeInputStream.class).processExited();
                }
                if (Target_java_lang_UNIXProcess.this.stdin != Target_java_lang_ProcessBuilder_NullOutputStream.INSTANCE) {
                    KnownIntrinsics.unsafeCast(Target_java_lang_UNIXProcess.this.stdin, Target_java_lang_UNIXProcess_ProcessPipeOutputStream.class).processExited();
                }
            }
        });
        reaperThread.start();
    }

    @Substitute
    @Platforms(value={Platform.LINUX.class, Platform.DARWIN.class})
    int waitForProcessExit(int ppid) {
        return PosixUtils.waitForProcessExit(ppid);
    }

    @Substitute
    @Platforms(value={Platform.LINUX.class, Platform.DARWIN.class})
    static void destroyProcess(int ppid, boolean force) {
        int sig = force ? Signal.SignalEnum.SIGKILL.getCValue() : Signal.SignalEnum.SIGTERM.getCValue();
        Signal.kill(ppid, sig);
    }
}

