/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.headers.Errno;
import com.oracle.svm.core.os.IsDefined;
import com.oracle.svm.core.posix.JavaNetNetUtil;
import com.oracle.svm.core.posix.JavaNetNetUtilMD;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.Target_java_net_DatagramSocketImpl;
import com.oracle.svm.core.posix.Target_java_net_InetAddress;
import com.oracle.svm.core.posix.Target_java_net_NetworkInterface;
import com.oracle.svm.core.posix.Target_java_net_PlainDatagramSocketImpl;
import com.oracle.svm.core.posix.Util_java_net_DatagramSocketImpl;
import com.oracle.svm.core.posix.Util_java_net_Inet4Address;
import com.oracle.svm.core.posix.Util_java_net_NetworkInterface;
import com.oracle.svm.core.posix.VmPrimsJVM;
import com.oracle.svm.core.posix.headers.NetinetIn;
import com.oracle.svm.core.posix.headers.Socket;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import java.io.FileDescriptor;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.PointerBase;

class Util_java_net_PlainDatagramSocketImpl {
    Util_java_net_PlainDatagramSocketImpl() {
    }

    static Target_java_net_DatagramSocketImpl as_Target_java_net_DatagramSocketImpl(Target_java_net_PlainDatagramSocketImpl tjnsi) {
        return KnownIntrinsics.unsafeCast(tjnsi, Target_java_net_DatagramSocketImpl.class);
    }

    static int getFD(Target_java_net_PlainDatagramSocketImpl self) {
        FileDescriptor fdObj = Util_java_net_DatagramSocketImpl.as_Target_java_net_DatagramSocketImpl((Target_java_net_PlainDatagramSocketImpl)self).fd;
        if (fdObj == null) {
            return -1;
        }
        return PosixUtils.getFD(fdObj);
    }

    static Object getMulticastInterface(int fd, int opt) throws SocketException {
        boolean isIPV4 = true;
        if (IsDefined.socket_AF_INET6() && JavaNetNetUtil.ipv6_available()) {
            isIPV4 = false;
        }
        if (isIPV4) {
            NetinetIn.in_addr inP = (NetinetIn.in_addr)StackValue.get(NetinetIn.in_addr.class);
            CIntPointer len_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
            if (VmPrimsJVM.JVM_GetSockOpt(fd, NetinetIn.IPPROTO_IP(), NetinetIn.IP_MULTICAST_IF(), (CCharPointer)inP, len_Pointer) < 0) {
                throw new SocketException(PosixUtils.lastErrorString("Error getting socket option"));
            }
            Inet4Address addr = Util_java_net_Inet4Address.new_Inet4Address();
            JavaNetNetUtil.setInetAddress_addr(addr, NetinetIn.ntohl(inP.s_addr()));
            if (opt == 16) {
                return addr;
            }
            NetworkInterface ni = Target_java_net_NetworkInterface.getByInetAddress0(addr);
            if (ni != null) {
                return ni;
            }
            ni = Util_java_net_NetworkInterface.newNetworkInterface();
            Util_java_net_NetworkInterface.fromNetworkInterface((NetworkInterface)ni).index = -1;
            InetAddress[] addrArray = new InetAddress[]{addr};
            Util_java_net_NetworkInterface.fromNetworkInterface((NetworkInterface)ni).addrs = addrArray;
            Util_java_net_NetworkInterface.fromNetworkInterface((NetworkInterface)ni).name = "";
            return ni;
        }
        if (IsDefined.socket_AF_INET6() && (opt == 16 || opt == 31)) {
            CCharPointer index_Pointer = (CCharPointer)StackValue.get(CCharPointer.class);
            index_Pointer.write((byte)0);
            CIntPointer len_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
            len_Pointer.write(SizeOf.get(CCharPointer.class));
            if (VmPrimsJVM.JVM_GetSockOpt(fd, NetinetIn.IPPROTO_IPV6(), NetinetIn.IPV6_MULTICAST_IF(), index_Pointer, len_Pointer) < 0) {
                throw new SocketException(PosixUtils.lastErrorString("Error getting socket option"));
            }
            if (index_Pointer.read() > 0) {
                NetworkInterface ni = Target_java_net_NetworkInterface.getByIndex0(index_Pointer.read());
                if (ni == null) {
                    throw new SocketException("IPV6_MULTICAST_IF returned index to unrecognized interface: " + index_Pointer.read());
                }
                if (opt == 31) {
                    return ni;
                }
                InetAddress[] addrArray = Util_java_net_NetworkInterface.fromNetworkInterface((NetworkInterface)ni).addrs;
                if (addrArray.length < 1) {
                    throw new SocketException("IPV6_MULTICAST_IF returned interface without IP bindings");
                }
                InetAddress addr = addrArray[0];
                return addr;
            }
            InetAddress addr = Target_java_net_InetAddress.anyLocalAddress();
            if (opt == 16) {
                return addr;
            }
            NetworkInterface ni = Util_java_net_NetworkInterface.newNetworkInterface();
            Util_java_net_NetworkInterface.fromNetworkInterface((NetworkInterface)ni).index = -1;
            InetAddress[] addrArray = new InetAddress[]{addr};
            Util_java_net_NetworkInterface.fromNetworkInterface((NetworkInterface)ni).addrs = addrArray;
            Util_java_net_NetworkInterface.fromNetworkInterface((NetworkInterface)ni).name = "";
            return ni;
        }
        return null;
    }

    static void setMulticastInterface(int fd, int opt, Object value) throws SocketException {
        if (opt == 16) {
            if (IsDefined.socket_AF_INET6()) {
                if (IsDefined.__linux__()) {
                    Util_java_net_PlainDatagramSocketImpl.mcast_set_if_by_addr_v4(fd, (InetAddress)value);
                    if (JavaNetNetUtil.ipv6_available()) {
                        Util_java_net_PlainDatagramSocketImpl.mcast_set_if_by_addr_v6(fd, (InetAddress)value);
                    }
                } else if (JavaNetNetUtil.ipv6_available()) {
                    Util_java_net_PlainDatagramSocketImpl.mcast_set_if_by_addr_v6(fd, (InetAddress)value);
                } else {
                    Util_java_net_PlainDatagramSocketImpl.mcast_set_if_by_addr_v4(fd, (InetAddress)value);
                }
            } else {
                Util_java_net_PlainDatagramSocketImpl.mcast_set_if_by_addr_v4(fd, (InetAddress)value);
            }
        }
        if (opt == 31) {
            if (IsDefined.socket_AF_INET6()) {
                if (IsDefined.__linux__()) {
                    Util_java_net_PlainDatagramSocketImpl.mcast_set_if_by_if_v4(fd, (NetworkInterface)value);
                    if (JavaNetNetUtil.ipv6_available()) {
                        Util_java_net_PlainDatagramSocketImpl.mcast_set_if_by_if_v6(fd, (NetworkInterface)value);
                    }
                } else if (JavaNetNetUtil.ipv6_available()) {
                    Util_java_net_PlainDatagramSocketImpl.mcast_set_if_by_if_v6(fd, (NetworkInterface)value);
                } else {
                    Util_java_net_PlainDatagramSocketImpl.mcast_set_if_by_if_v4(fd, (NetworkInterface)value);
                }
            } else {
                Util_java_net_PlainDatagramSocketImpl.mcast_set_if_by_if_v4(fd, (NetworkInterface)value);
            }
        }
    }

    static void mcast_set_if_by_addr_v4(int fd, InetAddress value) throws SocketException {
        NetinetIn.in_addr in = (NetinetIn.in_addr)StackValue.get(NetinetIn.in_addr.class);
        in.set_s_addr(NetinetIn.htonl(JavaNetNetUtilMD.getInetAddress_addr(value)));
        if (VmPrimsJVM.JVM_SetSockOpt(fd, NetinetIn.IPPROTO_IP(), NetinetIn.IP_MULTICAST_IF(), (CCharPointer)in, SizeOf.get(NetinetIn.in_addr.class)) < 0) {
            throw new SocketException(PosixUtils.lastErrorString("Error setting socket option"));
        }
    }

    static void mcast_set_if_by_if_v4(int fd, NetworkInterface value) throws SocketException {
        NetinetIn.in_addr in = (NetinetIn.in_addr)StackValue.get(NetinetIn.in_addr.class);
        InetAddress[] addrArray = Util_java_net_NetworkInterface.fromNetworkInterface((NetworkInterface)value).addrs;
        int len = addrArray.length;
        if (len < 1) {
            throw new SocketException("bad argument for IP_MULTICAST_IF2: No IP addresses bound to interface");
        }
        for (int i = 0; i < len; ++i) {
            InetAddress addr = addrArray[i];
            int family = JavaNetNetUtil.getInetAddress_family(addr);
            if (family != Target_java_net_InetAddress.IPv4) continue;
            in.set_s_addr(NetinetIn.htonl(JavaNetNetUtilMD.getInetAddress_addr(addr)));
            break;
        }
        if (VmPrimsJVM.JVM_SetSockOpt(fd, NetinetIn.IPPROTO_IP(), NetinetIn.IP_MULTICAST_IF(), (CCharPointer)in, SizeOf.get(NetinetIn.in_addr.class)) < 0) {
            throw new SocketException("Error setting socket option");
        }
    }

    static void mcast_set_if_by_if_v6(int fd, NetworkInterface value) throws SocketException {
        CIntPointer index_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        index_Pointer.write(Util_java_net_NetworkInterface.fromNetworkInterface((NetworkInterface)value).index);
        if (VmPrimsJVM.JVM_SetSockOpt(fd, NetinetIn.IPPROTO_IP(), NetinetIn.IPV6_MULTICAST_IF(), (CCharPointer)index_Pointer, SizeOf.get(CIntPointer.class)) < 0) {
            if (Errno.errno() == Errno.EINVAL() && index_Pointer.read() > 0) {
                throw new SocketException("IPV6_MULTICAST_IF failed (interface has IPv4 address only?");
            }
            throw new SocketException(PosixUtils.lastErrorString("Error setting socket option"));
        }
    }

    static void mcast_set_if_by_addr_v6(int fd, InetAddress valueArg) throws SocketException {
        NetworkInterface value = Target_java_net_NetworkInterface.getByInetAddress0(valueArg);
        if (value == null) {
            throw new SocketException("bad argument for IP_MULTICAST_IF: address not bound to any interface");
        }
        Util_java_net_PlainDatagramSocketImpl.mcast_set_if_by_if_v6(fd, value);
    }

    static void setMulticastLoopbackMode(int fd, int opt, Object value) throws SocketException {
        if (IsDefined.socket_AF_INET6()) {
            if (IsDefined.__linux__()) {
                Util_java_net_PlainDatagramSocketImpl.mcast_set_loop_v4(fd, (Boolean)value);
                if (JavaNetNetUtil.ipv6_available()) {
                    Util_java_net_PlainDatagramSocketImpl.mcast_set_loop_v6(fd, (Boolean)value);
                }
            } else if (JavaNetNetUtil.ipv6_available()) {
                Util_java_net_PlainDatagramSocketImpl.mcast_set_loop_v6(fd, (Boolean)value);
            } else {
                Util_java_net_PlainDatagramSocketImpl.mcast_set_loop_v4(fd, (Boolean)value);
            }
        } else {
            Util_java_net_PlainDatagramSocketImpl.mcast_set_loop_v4(fd, (Boolean)value);
        }
    }

    static void mcast_set_loop_v4(int fd, boolean value) throws SocketException {
        CCharPointer loopback_Pointer = (CCharPointer)StackValue.get(CCharPointer.class);
        boolean on = value;
        loopback_Pointer.write((byte)(!on ? 1 : 0));
        if (JavaNetNetUtilMD.NET_SetSockOpt(fd, NetinetIn.IPPROTO_IP(), NetinetIn.IP_MULTICAST_LOOP(), (WordPointer)loopback_Pointer, SizeOf.get(CCharPointer.class)) < 0) {
            throw new SocketException(PosixUtils.lastErrorString("Error setting socket option"));
        }
    }

    static void mcast_set_loop_v6(int fd, boolean value) throws SocketException {
        CIntPointer loopback_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        boolean on = value;
        loopback_Pointer.write(!on ? 1 : 0);
        if (JavaNetNetUtilMD.NET_SetSockOpt(fd, NetinetIn.IPPROTO_IPV6(), NetinetIn.IPV6_MULTICAST_LOOP(), (WordPointer)loopback_Pointer, SizeOf.get(CIntPointer.class)) < 0) {
            throw new SocketException(PosixUtils.lastErrorString("Error setting socket option"));
        }
    }

    static void setTTL(int fd, int ttl) throws SocketException {
        CCharPointer ittl_Pointer = (CCharPointer)StackValue.get(CCharPointer.class);
        ittl_Pointer.write((byte)ttl);
        if (Socket.setsockopt(fd, NetinetIn.IPPROTO_IP(), NetinetIn.IP_MULTICAST_TTL(), (PointerBase)ittl_Pointer, SizeOf.get(CCharPointer.class)) < 0) {
            throw new SocketException(PosixUtils.lastErrorString("Error setting socket option"));
        }
    }

    static void setHopLimit(int fd, int ttl) throws SocketException {
        CCharPointer ittl_Pointer = (CCharPointer)StackValue.get(CCharPointer.class);
        ittl_Pointer.write((byte)ttl);
        if (Socket.setsockopt(fd, NetinetIn.IPPROTO_IPV6(), NetinetIn.IPV6_MULTICAST_HOPS(), (PointerBase)ittl_Pointer, SizeOf.get(CCharPointer.class)) < 0) {
            throw new SocketException(PosixUtils.lastErrorString("Error setting socket option"));
        }
    }

    static Boolean createBoolean(boolean b) {
        return b;
    }

    static Boolean createBoolean(int i) {
        return CTypeConversion.toBoolean((int)i);
    }

    static Integer createInteger(int i) {
        return i;
    }

    static boolean not(byte b) {
        return !CTypeConversion.toBoolean((int)b);
    }

    static boolean not(int i) {
        return !CTypeConversion.toBoolean((int)i);
    }
}

