/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.stack;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.stack.PhysicalStackFrameVisitor;
import jdk.vm.ci.code.stack.InspectedFrameVisitor;
import jdk.vm.ci.code.stack.StackIntrospection;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.runtime.JVMCI;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;

public class SubstrateStackIntrospection
implements StackIntrospection {
    public static final SubstrateStackIntrospection SINGLETON = new SubstrateStackIntrospection();

    @NeverInline(value="Stack walking starts at the physical caller frame of this method")
    public <T> T iterateFrames(ResolvedJavaMethod[] initialMethods, ResolvedJavaMethod[] matchingMethods, int initialSkip, InspectedFrameVisitor<T> visitor) {
        if (SubstrateUtil.HOSTED) {
            StackIntrospection hostedStackIntrospection = JVMCI.getRuntime().getHostJVMCIBackend().getStackIntrospection();
            return (T)hostedStackIntrospection.iterateFrames(initialMethods, matchingMethods, initialSkip, visitor);
        }
        Pointer startSP = KnownIntrinsics.readCallerStackPointer();
        CodePointer startIP = KnownIntrinsics.readReturnAddress();
        PhysicalStackFrameVisitor<T> physicalFrameVisitor = new PhysicalStackFrameVisitor<T>(initialMethods, matchingMethods, initialSkip, visitor);
        JavaStackWalker.walkCurrentThread(startSP, startIP, physicalFrameVisitor);
        return physicalFrameVisitor.result;
    }
}

