/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.ameta;

import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.graal.meta.SharedConstantReflectionProvider;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.meta.ReadableJavaField;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.ameta.EmptyMemoryAcessProvider;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import java.lang.reflect.Modifier;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MemoryAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.WordBase;

@Platforms(value={Platform.HOSTED_ONLY.class})
public class AnalysisConstantReflectionProvider
extends SharedConstantReflectionProvider {
    private final AnalysisUniverse universe;
    private final ConstantReflectionProvider originalConstantReflection;
    private final ClassInitializationSupport classInitializationSupport;

    public AnalysisConstantReflectionProvider(AnalysisUniverse universe, ConstantReflectionProvider originalConstantReflection, ClassInitializationSupport classInitializationSupport) {
        this.universe = universe;
        this.originalConstantReflection = originalConstantReflection;
        this.classInitializationSupport = classInitializationSupport;
    }

    public MemoryAccessProvider getMemoryAccessProvider() {
        return EmptyMemoryAcessProvider.SINGLETON;
    }

    @Override
    public final JavaConstant readFieldValue(ResolvedJavaField field, JavaConstant receiver) {
        if (field instanceof AnalysisField) {
            return this.readValue((AnalysisField)field, receiver);
        }
        return super.readFieldValue(field, receiver);
    }

    public JavaConstant readValue(AnalysisField field, JavaConstant receiver) {
        if (this.classInitializationSupport.shouldInitializeAtRuntime((ResolvedJavaType)field.getDeclaringClass())) {
            if (field.isStatic()) {
                return JavaConstant.defaultForKind((JavaKind)field.getStorageKind());
            }
            throw VMError.shouldNotReachHere("Cannot read instance field of a class that is initialized at run time: " + field.format("%H.%n"));
        }
        return this.interceptValue(field, this.universe.lookup(ReadableJavaField.readFieldValue(this.originalConstantReflection, field.wrapped, this.universe.toHosted(receiver))));
    }

    public JavaConstant interceptValue(AnalysisField field, JavaConstant value) {
        JavaConstant result = value;
        if (result != null) {
            result = this.replaceObject(result);
            result = AnalysisConstantReflectionProvider.interceptAssertionStatus(field, result);
            result = this.interceptWordType(field, result);
        }
        return result;
    }

    private JavaConstant replaceObject(JavaConstant value) {
        Object oldObject;
        Object newObject;
        if (value == JavaConstant.NULL_POINTER) {
            return JavaConstant.NULL_POINTER;
        }
        if (value.getJavaKind() == JavaKind.Object && (newObject = this.universe.replaceObject(oldObject = this.universe.getSnippetReflection().asObject(Object.class, value))) != oldObject) {
            return this.universe.getSnippetReflection().forObject(newObject);
        }
        return value;
    }

    private static JavaConstant interceptAssertionStatus(AnalysisField field, JavaConstant value) {
        if (Modifier.isStatic(field.getModifiers()) && field.isSynthetic() && field.getName().startsWith("$assertionsDisabled")) {
            String unsubstitutedName = field.wrapped.getDeclaringClass().toJavaName();
            if (unsubstitutedName.startsWith("java.") || unsubstitutedName.startsWith("javax.") || unsubstitutedName.startsWith("sun.")) {
                return JavaConstant.TRUE;
            }
            String className = field.getDeclaringClass().toJavaName();
            return JavaConstant.forBoolean((!SubstrateOptions.getRuntimeAssertionsForClass(className) ? 1 : 0) != 0);
        }
        return value;
    }

    private JavaConstant interceptWordType(AnalysisField field, JavaConstant value) {
        if (value.getJavaKind() == JavaKind.Object) {
            Object originalObject = this.universe.getSnippetReflection().asObject(Object.class, value);
            if (this.universe.hostVM().isRelocatedPointer(originalObject)) {
                return value;
            }
            if (originalObject instanceof WordBase) {
                return JavaConstant.forIntegerKind((JavaKind)this.universe.getWordKind(), (long)((WordBase)originalObject).rawValue());
            }
            if (originalObject == null && field.getType().isWordType()) {
                return JavaConstant.forIntegerKind((JavaKind)this.universe.getWordKind(), (long)0L);
            }
        }
        return value;
    }

    public ResolvedJavaType asJavaType(Constant constant) {
        if (constant instanceof SubstrateObjectConstant) {
            Object obj = SubstrateObjectConstant.asObject(constant);
            if (obj instanceof DynamicHub) {
                return this.getHostVM().lookupType((DynamicHub)obj);
            }
            if (obj instanceof Class) {
                throw VMError.shouldNotReachHere("Must not have java.lang.Class object: " + obj);
            }
        }
        return null;
    }

    public JavaConstant asJavaClass(ResolvedJavaType type) {
        DynamicHub dynamicHub = this.getHostVM().dynamicHub(type);
        assert (dynamicHub != null) : type.toClassName() + " has a null dynamicHub.";
        AnalysisConstantReflectionProvider.registerHub(this.getHostVM(), dynamicHub);
        return SubstrateObjectConstant.forObject(dynamicHub);
    }

    private SVMHost getHostVM() {
        return (SVMHost)this.universe.hostVM();
    }

    protected static void registerHub(SVMHost hostVM, DynamicHub dynamicHub) {
        assert (dynamicHub != null);
        AnalysisType valueType = hostVM.lookupType(dynamicHub);
        if (!valueType.isInTypeCheck()) {
            valueType.registerAsInTypeCheck();
        }
    }
}

