/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jni.access;

import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.jni.access.JNIAccessibleClass;
import com.oracle.svm.jni.nativeapi.JNIFieldId;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class JNIAccessibleField {
    private static final UnsignedWord ID_STATIC_FLAG = WordFactory.unsigned((long)-1L).unsignedShiftRight(1).add(1);
    private static final UnsignedWord ID_OBJECT_FLAG = ID_STATIC_FLAG.unsignedShiftRight(1);
    private static final UnsignedWord ID_OFFSET_MASK = ID_OBJECT_FLAG.subtract(1);
    private final JNIAccessibleClass declaringClass;
    private final String name;
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private final UnsignedWord flags;
    private UnsignedWord id = (UnsignedWord)WordFactory.zero();

    public static WordBase getOffsetFromId(JNIFieldId id) {
        return ((UnsignedWord)id).and(ID_OFFSET_MASK);
    }

    JNIAccessibleField(JNIAccessibleClass declaringClass, String name, JavaKind kind, int modifiers) {
        this.declaringClass = declaringClass;
        this.name = name;
        UnsignedWord bits = Modifier.isStatic(modifiers) ? ID_STATIC_FLAG : (UnsignedWord)WordFactory.zero();
        this.flags = bits = bits.or(kind.isObject() ? ID_OBJECT_FLAG : (UnsignedWord)WordFactory.zero());
    }

    public JNIFieldId getId() {
        return (JNIFieldId)this.id;
    }

    public boolean isStatic() {
        assert (!this.id.equal(0));
        return this.id.and(ID_STATIC_FLAG).notEqual(0);
    }

    void fillOffset(FeatureImpl.CompilationAccessImpl access) {
        assert (this.id.equal(0));
        try {
            Field reflField = this.declaringClass.getClassObject().getDeclaredField(this.name);
            HostedField field = access.getMetaAccess().lookupJavaField(reflField);
            assert (field.hasLocation());
            int offset = field.getLocation();
            assert (ID_OFFSET_MASK.and(offset).equal(offset));
            this.id = this.flags.or(offset);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

