/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.jdk11.linux;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.headers.Errno;
import com.oracle.svm.core.jdk.JDK11OrLater;
import com.oracle.svm.core.posix.PosixJavaNetClose;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.headers.NetinetTcp;
import com.oracle.svm.core.posix.headers.Socket;
import com.oracle.svm.core.posix.jdk11.linux.Util_jdk_net_LinuxSocketOptions;
import java.net.SocketException;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.word.PointerBase;

@TargetClass(className="jdk.net.LinuxSocketOptions", onlyWith={JDK11OrLater.class})
@Platforms(value={Platform.LINUX.class})
public final class Target_jdk_net_LinuxSocketOptions {
    @Substitute
    private static boolean keepAliveOptionsSupported0() {
        return Util_jdk_net_LinuxSocketOptions.socketOptionSupported(NetinetTcp.TCP_KEEPIDLE()) != 0 && Util_jdk_net_LinuxSocketOptions.socketOptionSupported(NetinetTcp.TCP_KEEPCNT()) != 0 && Util_jdk_net_LinuxSocketOptions.socketOptionSupported(NetinetTcp.TCP_KEEPINTVL()) != 0;
    }

    @Substitute
    private static void setTcpkeepAliveProbes0(int fd, int optval) throws SocketException {
        CIntPointer optval_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        optval_Pointer.write(optval);
        int rv = Socket.setsockopt(fd, NetinetTcp.SOL_TCP(), NetinetTcp.TCP_KEEPCNT(), (PointerBase)optval_Pointer, SizeOf.get(CIntPointer.class));
        Util_jdk_net_LinuxSocketOptions.handleError(rv, "set option TCP_KEEPCNT failed");
    }

    @Substitute
    private static void setTcpKeepAliveTime0(int fd, int optval) throws SocketException {
        CIntPointer optval_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        optval_Pointer.write(optval);
        int rv = Socket.setsockopt(fd, NetinetTcp.SOL_TCP(), NetinetTcp.TCP_KEEPIDLE(), (PointerBase)optval_Pointer, SizeOf.get(CIntPointer.class));
        Util_jdk_net_LinuxSocketOptions.handleError(rv, "set option TCP_KEEPIDLE failed");
    }

    @Substitute
    private static void setTcpKeepAliveIntvl0(int fd, int optval) throws SocketException {
        CIntPointer optval_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        optval_Pointer.write(optval);
        int rv = Socket.setsockopt(fd, NetinetTcp.SOL_TCP(), NetinetTcp.TCP_KEEPINTVL(), (PointerBase)optval_Pointer, SizeOf.get(CIntPointer.class));
        Util_jdk_net_LinuxSocketOptions.handleError(rv, "set option TCP_KEEPINTVL failed");
    }

    @Substitute
    private static int getTcpkeepAliveProbes0(int fd) throws SocketException {
        CIntPointer optval_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        CIntPointer sz_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        sz_Pointer.write(SizeOf.get(CIntPointer.class));
        int rv = Socket.getsockopt(fd, NetinetTcp.SOL_TCP(), NetinetTcp.TCP_KEEPCNT(), (PointerBase)optval_Pointer, sz_Pointer);
        Util_jdk_net_LinuxSocketOptions.handleError(rv, "get option TCP_KEEPCNT failed");
        return optval_Pointer.read();
    }

    @Substitute
    private static int getTcpKeepAliveTime0(int fd) throws SocketException {
        CIntPointer optval_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        CIntPointer sz_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        sz_Pointer.write(SizeOf.get(CIntPointer.class));
        int rv = Socket.getsockopt(fd, NetinetTcp.SOL_TCP(), NetinetTcp.TCP_KEEPIDLE(), (PointerBase)optval_Pointer, sz_Pointer);
        Util_jdk_net_LinuxSocketOptions.handleError(rv, "get option TCP_KEEPIDLE failed");
        return optval_Pointer.read();
    }

    @Substitute
    private static int getTcpKeepAliveIntvl0(int fd) throws SocketException {
        CIntPointer optval_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        CIntPointer sz_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        sz_Pointer.write(SizeOf.get(CIntPointer.class));
        int rv = Socket.getsockopt(fd, NetinetTcp.SOL_TCP(), NetinetTcp.TCP_KEEPINTVL(), (PointerBase)optval_Pointer, sz_Pointer);
        Util_jdk_net_LinuxSocketOptions.handleError(rv, "get option TCP_KEEPINTVL failed");
        return optval_Pointer.read();
    }

    @Substitute
    private static void setQuickAck0(int fd, boolean on) throws SocketException {
        CIntPointer optval_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        optval_Pointer.write(on ? 1 : 0);
        int rv = Socket.setsockopt(fd, Socket.SOL_SOCKET(), NetinetTcp.TCP_QUICKACK(), (PointerBase)optval_Pointer, SizeOf.get(CIntPointer.class));
        if (rv < 0) {
            if (Errno.errno() == Errno.ENOPROTOOPT()) {
                throw new UnsupportedOperationException("unsupported socket option");
            }
            throw new SocketException(PosixUtils.lastErrorString("set option TCP_QUICKACK failed"));
        }
    }

    @Substitute
    private static boolean getQuickAck0(int fd) throws SocketException {
        CIntPointer on_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        CIntPointer sz_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        sz_Pointer.write(SizeOf.get(CIntPointer.class));
        int rv = Socket.getsockopt(fd, Socket.SOL_SOCKET(), NetinetTcp.TCP_QUICKACK(), (PointerBase)on_Pointer, sz_Pointer);
        if (rv < 0) {
            if (Errno.errno() == Errno.ENOPROTOOPT()) {
                throw new UnsupportedOperationException("unsupported socket option");
            }
            throw new SocketException(PosixUtils.lastErrorString("get option TCP_QUICKACK failed"));
        }
        return on_Pointer.read() != 0;
    }

    @Substitute
    private static boolean quickAckSupported0() {
        CIntPointer one_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        int s = Socket.socket(Socket.PF_INET(), Socket.SOCK_STREAM(), 0);
        if (s < 0) {
            return false;
        }
        int rv = Socket.setsockopt(s, Socket.SOL_SOCKET(), NetinetTcp.TCP_QUICKACK(), (PointerBase)one_Pointer, SizeOf.get(CIntPointer.class));
        rv = rv != 0 && Errno.errno() == Errno.ENOPROTOOPT() ? 0 : 1;
        ((PosixJavaNetClose)ImageSingletons.lookup(PosixJavaNetClose.class)).NET_SocketClose(s);
        return rv != 0;
    }
}

