/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows.headers;

import com.oracle.svm.core.windows.headers.WindowsDirectives;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.constant.CConstant;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.struct.AllowWideningCast;
import org.graalvm.nativeimage.c.struct.CField;
import org.graalvm.nativeimage.c.struct.CPointerTo;
import org.graalvm.nativeimage.c.struct.CStruct;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.CLongPointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

@CContext(value=WindowsDirectives.class)
@Platforms(value={Platform.WINDOWS.class})
public class WinBase {
    public static final int MAX_PATH = 260;

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native boolean GlobalMemoryStatusEx(MEMORYSTATUSEX var0);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native void GetSystemInfo(SYSTEM_INFO var0);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native Pointer CreateFileMapping(long var0, Pointer var2, int var3, int var4, int var5, Pointer var6);

    @CConstant
    public static native int FILE_MAP_EXECUTE();

    @CConstant
    public static native int FILE_MAP_READ();

    @CConstant
    public static native int FILE_MAP_WRITE();

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native Pointer MapViewOfFile(Pointer var0, int var1, int var2, int var3, UnsignedWord var4);

    @CConstant
    public static native int MEM_COMMIT();

    @CConstant
    public static native int MEM_RESERVE();

    @CConstant
    public static native int MEM_RESET();

    @CConstant
    public static native int MEM_LARGE_PAGES();

    @CConstant
    public static native int MEM_PHYSICAL();

    @CConstant
    public static native int MEM_TOP_DOWN();

    @CConstant
    public static native int MEM_WRITE_WATCH();

    @CConstant
    public static native int PAGE_EXECUTE();

    @CConstant
    public static native int PAGE_EXECUTE_READ();

    @CConstant
    public static native int PAGE_EXECUTE_READWRITE();

    @CConstant
    public static native int PAGE_GUARD();

    @CConstant
    public static native int PAGE_NOACCESS();

    @CConstant
    public static native int PAGE_NOCACHE();

    @CConstant
    public static native int PAGE_READONLY();

    @CConstant
    public static native int PAGE_READWRITE();

    @CConstant
    public static native int PAGE_WRITECOMBINE();

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native Pointer VirtualAlloc(PointerBase var0, UnsignedWord var1, int var2, int var3);

    @CConstant
    public static native int MEM_DECOMMIT();

    @CConstant
    public static native int MEM_RELEASE();

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native int VirtualFree(PointerBase var0, UnsignedWord var1, int var2);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native int VirtualProtect(PointerBase var0, UnsignedWord var1, int var2, CIntPointer var3);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native int GetLastError();

    @CConstant
    public static native int ERROR_TIMEOUT();

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native void QueryPerformanceCounter(CLongPointer var0);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native void QueryPerformanceFrequency(CLongPointer var0);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native int CloseHandle(HANDLE var0);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native HMODULE GetModuleHandleA(PointerBase var0);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native int GetModuleFileNameA(HMODULE var0, CCharPointer var1, int var2);

    @CConstant
    public static native int GET_MODULE_HANDLE_EX_FLAG_FROM_ADDRESS();

    @CConstant
    public static native int GET_MODULE_HANDLE_EX_FLAG_UNCHANGED_REFCOUNT();

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native boolean GetModuleHandleExA(int var0, PointerBase var1, HMODULEPointer var2);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native PointerBase GetProcAddress(HMODULE var0, PointerBase var1);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native HMODULE LoadLibraryA(PointerBase var0);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native HMODULE LoadLibraryExA(PointerBase var0, int var1, int var2);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native void FreeLibrary(PointerBase var0);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native boolean SetDllDirectoryA(PointerBase var0);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native UnsignedWord VirtualQuery(PointerBase var0, MEMORY_BASIC_INFORMATION var1, UnsignedWord var2);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native int GetVersion();

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native int GetCurrentDirectoryA(long var0, CCharPointer var2);

    @CStruct(addStructKeyword=false)
    public static interface MEMORY_BASIC_INFORMATION
    extends PointerBase {
        @CField
        public Pointer BaseAddress();

        @CField
        public Pointer AllocationBase();

        @CField
        public int AllocationProtect();

        @CField
        public UnsignedWord RegionSize();

        @CField
        public int State();

        @CField
        public int Protect();

        @CField
        public int Type();
    }

    @CStruct(addStructKeyword=false)
    public static interface SYSTEM_INFO
    extends PointerBase {
        @CField
        @AllowWideningCast
        public int wProcessorArchitecture();

        @CField
        @AllowWideningCast
        public int wReserved();

        @CField
        @AllowWideningCast
        public int dwPageSize();

        @CField
        public Pointer lpMinimumApplicationAddress();

        @CField
        public Pointer lpMaximumApplicationAddress();

        @CField
        @AllowWideningCast
        public long dwActiveProcessorMask();

        @CField
        @AllowWideningCast
        public int dwNumberOfProcessors();

        @CField
        @AllowWideningCast
        public int dwProcessorType();

        @CField
        @AllowWideningCast
        public int dwAllocationGranularity();

        @CField
        @AllowWideningCast
        public short wProcessorLevel();

        @CField
        @AllowWideningCast
        public short wProcessorRevision();
    }

    @CStruct(addStructKeyword=false)
    public static interface MEMORYSTATUSEX
    extends PointerBase {
        @CField
        @AllowWideningCast
        public int dwLength();

        @CField
        public void set_dwLength(int var1);

        @CField
        @AllowWideningCast
        public int dwMemoryLoad();

        @CField
        public long ullTotalPhys();

        @CField
        public long ullAvailPhys();

        @CField
        public long ullTotalPageFile();

        @CField
        public long ullAvailPageFile();

        @CField
        public long ullTotalVirtual();

        @CField
        public long ullAvailVirtual();

        @CField
        public long ullAvailExtendedVirtual();
    }

    @CPointerTo(nameOfCType="HMODULE")
    public static interface HMODULEPointer
    extends PointerBase {
        public HMODULE read();

        public void write(HMODULE var1);
    }

    public static interface HMODULE
    extends PointerBase {
    }

    public static interface HANDLE
    extends WordBase {
    }
}

