/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.substitute;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.AnnotateOriginal;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.Inject;
import com.oracle.svm.core.annotate.InjectAccessors;
import com.oracle.svm.core.annotate.KeepOriginal;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.configure.ConfigurationFiles;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.OptionUtils;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.core.util.json.JSONParser;
import com.oracle.svm.core.util.json.JSONParserException;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.substitute.AliasImpl;
import com.oracle.svm.hosted.substitute.AnnotateOriginalImpl;
import com.oracle.svm.hosted.substitute.AnnotationSubstitutionProcessor;
import com.oracle.svm.hosted.substitute.ClassDescriptor;
import com.oracle.svm.hosted.substitute.DeleteImpl;
import com.oracle.svm.hosted.substitute.ElementDescriptor;
import com.oracle.svm.hosted.substitute.FieldDescriptor;
import com.oracle.svm.hosted.substitute.InjectImpl;
import com.oracle.svm.hosted.substitute.KeepOriginalImpl;
import com.oracle.svm.hosted.substitute.MethodDescriptor;
import com.oracle.svm.hosted.substitute.PlatformsDescriptor;
import com.oracle.svm.hosted.substitute.SubstituteImpl;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.nativeimage.Platforms;

public class DeclarativeSubstitutionProcessor
extends AnnotationSubstitutionProcessor {
    private final Map<Class<?>, ClassDescriptor> classDescriptors = new HashMap();
    private final Map<Executable, MethodDescriptor> methodDescriptors = new HashMap<Executable, MethodDescriptor>();
    private final Map<Field, FieldDescriptor> fieldDescriptors = new HashMap<Field, FieldDescriptor>();

    public DeclarativeSubstitutionProcessor(ImageClassLoader imageClassLoader, MetaAccessProvider metaAccess, ClassInitializationSupport classInitializationSupport) {
        super(imageClassLoader, metaAccess, classInitializationSupport);
        for (String substitutionFileName : OptionUtils.flatten(",", ConfigurationFiles.Options.SubstitutionFiles.getValue())) {
            try {
                this.loadFile(new FileReader(substitutionFileName));
            }
            catch (FileNotFoundException ex) {
                throw UserError.abort("Substitution file " + substitutionFileName + " not found.");
            }
            catch (JSONParserException | IOException ex) {
                throw UserError.abort("Could not parse substitution file " + substitutionFileName + ": " + ex.getMessage());
            }
        }
        for (String substitutionResourceName : OptionUtils.flatten(",", Options.SubstitutionResources.getValue())) {
            try {
                InputStream substitutionStream = imageClassLoader.findResourceAsStreamByName(substitutionResourceName);
                if (substitutionStream == null) {
                    throw UserError.abort("Substitution resource not found: " + substitutionResourceName);
                }
                this.loadFile(new InputStreamReader(substitutionStream));
            }
            catch (JSONParserException | IOException ex) {
                throw UserError.abort("Could not parse substitution resource " + substitutionResourceName + ": " + ex.getMessage());
            }
        }
    }

    private void loadFile(Reader reader) throws IOException {
        HashSet annotatedClasses = new HashSet(this.imageClassLoader.findAnnotatedClasses(TargetClass.class, false));
        JSONParser parser = new JSONParser(reader);
        List allDescriptors = (List)parser.parse();
        for (Object classDescriptorData : allDescriptors) {
            if (classDescriptorData == null) continue;
            ClassDescriptor classDescriptor = new ClassDescriptor(classDescriptorData);
            Class<?> annotatedClass = this.imageClassLoader.findClassByName(classDescriptor.annotatedClass());
            if (annotatedClasses.contains(annotatedClass)) {
                throw UserError.abort("target class already registered using explicit @TargetClass annotation: " + annotatedClass);
            }
            if (this.classDescriptors.containsKey(annotatedClass)) {
                throw UserError.abort("target class already registered using substitution file: " + annotatedClass);
            }
            this.classDescriptors.put(annotatedClass, classDescriptor);
            for (Object methodDescriptorData : classDescriptor.methods()) {
                if (methodDescriptorData == null) continue;
                MethodDescriptor methodDescriptor = new MethodDescriptor(methodDescriptorData);
                Executable annotatedMethod = methodDescriptor.parameterTypes() != null ? this.findMethod(annotatedClass, methodDescriptor.annotatedName(), methodDescriptor.parameterTypes()) : DeclarativeSubstitutionProcessor.findMethod(annotatedClass, methodDescriptor.annotatedName(), true);
                this.methodDescriptors.put(annotatedMethod, methodDescriptor);
            }
            for (Object fieldDescriptorData : classDescriptor.fields()) {
                FieldDescriptor fieldDescriptor = new FieldDescriptor(fieldDescriptorData);
                Field annotatedField = DeclarativeSubstitutionProcessor.findField(annotatedClass, fieldDescriptor.annotatedName());
                this.fieldDescriptors.put(annotatedField, fieldDescriptor);
            }
        }
    }

    private static Executable findMethod(Class<?> declaringClass, String methodName, boolean fatalIfNotUnique) {
        Executable result = null;
        if (methodName.equals("<init>")) {
            for (Constructor<?> c : declaringClass.getDeclaredConstructors()) {
                if (result != null) {
                    UserError.guarantee(!fatalIfNotUnique, "two constructors found: %s, %s ", result, c);
                    return null;
                }
                result = c;
            }
            UserError.guarantee(!fatalIfNotUnique || result != null, "no constructor found: %s", declaringClass);
        } else {
            for (Method m : declaringClass.getDeclaredMethods()) {
                if (!m.getName().equals(methodName)) continue;
                if (result != null) {
                    UserError.guarantee(!fatalIfNotUnique, "two methods with same name found: %s, %s ", result, m);
                    return null;
                }
                result = m;
            }
            UserError.guarantee(!fatalIfNotUnique || result != null, "method not found: %s, method name %s", declaringClass, methodName);
        }
        return result;
    }

    private Executable findMethod(Class<?> declaringClass, String methodName, String[] parameterTypeNames) {
        Class[] parameterTypes = new Class[parameterTypeNames.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameterTypes[i] = this.imageClassLoader.findClassByName(parameterTypeNames[i]);
        }
        try {
            if (methodName.equals("<init>")) {
                return declaringClass.getDeclaredConstructor(parameterTypes);
            }
            return declaringClass.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw VMError.shouldNotReachHere("method not found: " + declaringClass + ", method name " + methodName + ", parameter types " + Arrays.toString(parameterTypeNames));
        }
    }

    private static Field findField(Class<?> declaringClass, String fieldName) {
        try {
            return declaringClass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    @Override
    protected List<Class<?>> findTargetClasses() {
        List<Class<?>> result = super.findTargetClasses();
        result.addAll(this.classDescriptors.keySet());
        return result;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected <T extends Annotation> T lookupAnnotation(AnnotatedElement element, Class<T> annotationClass) {
        void var3_28;
        if (element instanceof Class && this.classDescriptors.containsKey(element)) {
            ClassDescriptor classDescriptor = this.classDescriptors.get(element);
            if (annotationClass == Platforms.class) {
                PlatformsDescriptor.PlatformsImpl platformsImpl;
                if (classDescriptor.platforms() != null) {
                    ClassDescriptor classDescriptor2 = classDescriptor;
                    classDescriptor2.getClass();
                    platformsImpl = new PlatformsDescriptor.PlatformsImpl(classDescriptor2, this.imageClassLoader);
                } else {
                    platformsImpl = null;
                }
                PlatformsDescriptor.PlatformsImpl platformsImpl2 = platformsImpl;
                return (T)((Annotation)annotationClass.cast(var3_28));
            } else if (annotationClass == TargetClass.class) {
                ClassDescriptor.TargetClassImpl targetClassImpl = classDescriptor.new ClassDescriptor.TargetClassImpl();
                return (T)((Annotation)annotationClass.cast(var3_28));
            } else if (annotationClass == Delete.class) {
                DeleteImpl deleteImpl = classDescriptor.delete() ? new DeleteImpl() : null;
                return (T)((Annotation)annotationClass.cast(var3_28));
            } else {
                if (annotationClass != Substitute.class) throw VMError.shouldNotReachHere("Unexpected annotation type: " + annotationClass.getName());
                SubstituteImpl substituteImpl = classDescriptor.substitute() ? new SubstituteImpl() : null;
            }
            return (T)((Annotation)annotationClass.cast(var3_28));
        } else if (element instanceof Executable && this.methodDescriptors.containsKey(element)) {
            MethodDescriptor methodDescriptor = this.methodDescriptors.get(element);
            if (annotationClass == Platforms.class) {
                PlatformsDescriptor.PlatformsImpl platformsImpl;
                if (methodDescriptor.platforms() != null) {
                    MethodDescriptor methodDescriptor2 = methodDescriptor;
                    methodDescriptor2.getClass();
                    platformsImpl = new PlatformsDescriptor.PlatformsImpl(methodDescriptor2, this.imageClassLoader);
                } else {
                    platformsImpl = null;
                }
                PlatformsDescriptor.PlatformsImpl platformsImpl3 = platformsImpl;
                return (T)((Annotation)annotationClass.cast(var3_28));
            } else if (annotationClass == TargetElement.class) {
                ElementDescriptor.TargetElementImpl targetElementImpl = new ElementDescriptor.TargetElementImpl(methodDescriptor);
                return (T)((Annotation)annotationClass.cast(var3_28));
            } else if (annotationClass == Delete.class) {
                DeleteImpl deleteImpl = methodDescriptor.delete() ? new DeleteImpl() : null;
                return (T)((Annotation)annotationClass.cast(var3_28));
            } else if (annotationClass == Substitute.class) {
                SubstituteImpl substituteImpl = methodDescriptor.substitute() ? new SubstituteImpl() : null;
                return (T)((Annotation)annotationClass.cast(var3_28));
            } else if (annotationClass == AnnotateOriginal.class) {
                AnnotateOriginalImpl annotateOriginalImpl = methodDescriptor.annotateOriginal() ? new AnnotateOriginalImpl() : null;
                return (T)((Annotation)annotationClass.cast(var3_28));
            } else if (annotationClass == KeepOriginal.class) {
                KeepOriginalImpl keepOriginalImpl = methodDescriptor.keepOriginal() ? new KeepOriginalImpl() : null;
                return (T)((Annotation)annotationClass.cast(var3_28));
            } else {
                if (annotationClass != Alias.class) throw VMError.shouldNotReachHere("Unexpected annotation type: " + annotationClass.getName());
                AliasImpl aliasImpl = methodDescriptor.alias() ? new AliasImpl() : null;
            }
            return (T)((Annotation)annotationClass.cast(var3_28));
        } else if (element instanceof Field && this.fieldDescriptors.containsKey(element)) {
            FieldDescriptor fieldDescriptor = this.fieldDescriptors.get(element);
            if (annotationClass == Platforms.class) {
                PlatformsDescriptor.PlatformsImpl platformsImpl;
                if (fieldDescriptor.platforms() != null) {
                    FieldDescriptor fieldDescriptor2 = fieldDescriptor;
                    fieldDescriptor2.getClass();
                    platformsImpl = new PlatformsDescriptor.PlatformsImpl(fieldDescriptor2, this.imageClassLoader);
                } else {
                    platformsImpl = null;
                }
                PlatformsDescriptor.PlatformsImpl platformsImpl4 = platformsImpl;
                return (T)((Annotation)annotationClass.cast(var3_28));
            } else if (annotationClass == TargetElement.class) {
                ElementDescriptor.TargetElementImpl targetElementImpl = new ElementDescriptor.TargetElementImpl(fieldDescriptor);
                return (T)((Annotation)annotationClass.cast(var3_28));
            } else if (annotationClass == Delete.class) {
                DeleteImpl deleteImpl = fieldDescriptor.delete() ? new DeleteImpl() : null;
                return (T)((Annotation)annotationClass.cast(var3_28));
            } else if (annotationClass == Alias.class) {
                AliasImpl aliasImpl = fieldDescriptor.alias() ? new AliasImpl() : null;
                return (T)((Annotation)annotationClass.cast(var3_28));
            } else if (annotationClass == Inject.class) {
                InjectImpl injectImpl = fieldDescriptor.inject() ? new InjectImpl() : null;
                return (T)((Annotation)annotationClass.cast(var3_28));
            } else if (annotationClass == RecomputeFieldValue.class) {
                FieldDescriptor.RecomputeFieldValueImpl recomputeFieldValueImpl = fieldDescriptor.kind() != null ? fieldDescriptor.new FieldDescriptor.RecomputeFieldValueImpl() : null;
                return (T)((Annotation)annotationClass.cast(var3_28));
            } else {
                FieldDescriptor.InjectAccessorsImpl injectAccessorsImpl;
                if (annotationClass != InjectAccessors.class) throw VMError.shouldNotReachHere("Unexpected annotation type: " + annotationClass.getName());
                if (fieldDescriptor.injectAccessors() != null) {
                    FieldDescriptor fieldDescriptor3 = fieldDescriptor;
                    fieldDescriptor3.getClass();
                    injectAccessorsImpl = fieldDescriptor3.new FieldDescriptor.InjectAccessorsImpl(this.imageClassLoader);
                } else {
                    injectAccessorsImpl = null;
                }
                FieldDescriptor.InjectAccessorsImpl injectAccessorsImpl2 = injectAccessorsImpl;
            }
            return (T)((Annotation)annotationClass.cast(var3_28));
        } else {
            T t = super.lookupAnnotation(element, annotationClass);
        }
        return (T)((Annotation)annotationClass.cast(var3_28));
    }

    public static class Options {
        @Option(help={"Comma-separated list of resource file names with declarative substitutions"}, type=OptionType.User)
        public static final HostedOptionKey<String[]> SubstitutionResources = new HostedOptionKey<Object>(null);
    }
}

