/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.api;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.deopt.SubstrateSpeculationLog;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.option.RuntimeOptionParser;
import com.oracle.svm.core.option.RuntimeOptionValues;
import com.oracle.svm.core.stack.SubstrateStackIntrospection;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.GraalSupport;
import com.oracle.svm.graal.SubstrateGraalUtils;
import com.oracle.svm.graal.hosted.GraalFeature;
import com.oracle.svm.hosted.c.GraalAccess;
import com.oracle.svm.truffle.TruffleFeature;
import com.oracle.svm.truffle.api.SubstrateTruffleCompiler;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.OptimizationFailedException;
import com.oracle.truffle.api.nodes.RootNode;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import jdk.vm.ci.code.stack.StackIntrospection;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.collections.UnmodifiableMapCursor;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.api.runtime.GraalRuntime;
import org.graalvm.compiler.debug.TTY;
import org.graalvm.compiler.options.OptionDescriptor;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;
import org.graalvm.compiler.truffle.runtime.BackgroundCompileQueue;
import org.graalvm.compiler.truffle.runtime.CancellableCompileTask;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntime;
import org.graalvm.compiler.truffle.runtime.LoopNodeFactory;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.SharedTruffleRuntimeOptions;
import org.graalvm.compiler.truffle.runtime.TruffleRuntimeOptions;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class SubstrateTruffleRuntime
extends GraalTruffleRuntime {
    private static final int DEBUG_TEAR_DOWN_TIMEOUT = 2000;
    private static final int PRODUCTION_TEAR_DOWN_TIMEOUT = 10000;
    private BackgroundCompileQueue compileQueue;
    private GraalTruffleRuntime.CallMethods hostedCallMethods;
    private boolean initialized;
    private final Supplier<GraalRuntime> graalRuntimeProvider = () -> (GraalRuntime)ImageSingletons.lookup(GraalRuntime.class);

    protected BackgroundCompileQueue getCompileQueue() {
        assert (this.compileQueue != null);
        return this.compileQueue;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SubstrateTruffleRuntime() {
        super(Collections.emptyList());
        super.getLoopNodeFactory();
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void resetHosted() {
        this.truffleCompiler = null;
    }

    public void initializeAtRuntime() {
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            this.compileQueue = new BackgroundCompileQueue();
            RuntimeSupport.getRuntimeSupport().addTearDownHook(this::tearDown);
        }
        if (((Boolean)TruffleRuntimeOptions.getValue((org.graalvm.options.OptionKey)SharedTruffleRuntimeOptions.TraceTruffleTransferToInterpreter)).booleanValue()) {
            if (!SubstrateOptions.IncludeNodeSourcePositions.getValue().booleanValue()) {
                Log.log().string("Warning: TraceTruffleTransferToInterpreter cannot print stack traces. Build image with -H:+IncludeNodeSourcePositions to enable stack traces.").newline();
            }
            RuntimeOptionValues.singleton().update(Deoptimizer.Options.TraceDeoptimization, true);
        }
        SubstrateGraalUtils.updateGraalArchitectureWithHostCPUFeatures(this.getTruffleCompiler().getBackend());
        this.installDefaultListeners();
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SubstrateTruffleCompiler initTruffleCompiler() {
        assert (this.truffleCompiler == null) : "Cannot re-initialize Substrate TruffleCompiler";
        GraalFeature graalFeature = (GraalFeature)ImageSingletons.lookup(GraalFeature.class);
        SnippetReflectionProvider snippetReflection = graalFeature.getHostedProviders().getSnippetReflection();
        SubstrateTruffleCompiler compiler = new SubstrateTruffleCompiler((TruffleCompilerRuntime)this, graalFeature.getHostedProviders().getGraphBuilderPlugins(), GraalSupport.getSuites(), GraalSupport.getLIRSuites(), GraalSupport.getRuntimeConfig().getBackendForNormalMethod(), GraalSupport.getFirstTierSuites(), GraalSupport.getFirstTierLirSuites(), GraalSupport.getFirstTierProviders(), snippetReflection);
        this.truffleCompiler = compiler;
        return compiler;
    }

    public ResolvedJavaMethod[] getAnyFrameMethod() {
        return this.callMethods.anyFrameMethod;
    }

    protected String getCompilerConfigurationName() {
        SubstrateTruffleCompiler compiler = this.getTruffleCompiler();
        if (compiler != null) {
            return compiler.getCompilerConfigurationName();
        }
        return null;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SubstrateTruffleCompiler newTruffleCompiler() {
        GraalFeature graalFeature = (GraalFeature)ImageSingletons.lookup(GraalFeature.class);
        SnippetReflectionProvider snippetReflectionProvider = graalFeature.getHostedProviders().getSnippetReflection();
        return new SubstrateTruffleCompiler((TruffleCompilerRuntime)this, graalFeature.getHostedProviders().getGraphBuilderPlugins(), GraalSupport.getSuites(), GraalSupport.getLIRSuites(), GraalSupport.getRuntimeConfig().getBackendForNormalMethod(), GraalSupport.getFirstTierSuites(), GraalSupport.getFirstTierLirSuites(), GraalSupport.getFirstTierProviders(), snippetReflectionProvider);
    }

    private void tearDown() {
        long timeout = SubstrateUtil.assertionsEnabled() ? 2000L : 10000L;
        this.getCompileQueue().shutdownAndAwaitTermination(timeout);
    }

    public SubstrateTruffleCompiler getTruffleCompiler() {
        return (SubstrateTruffleCompiler)this.truffleCompiler;
    }

    protected LoopNodeFactory getLoopNodeFactory() {
        if (this.loopNodeFactory == null) {
            throw VMError.shouldNotReachHere("loopNodeFactory not initialized");
        }
        return this.loopNodeFactory;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void lookupCallMethods(MetaAccessProvider metaAccess) {
        super.lookupCallMethods(metaAccess);
        this.hostedCallMethods = GraalTruffleRuntime.CallMethods.lookup((MetaAccessProvider)GraalAccess.getOriginalProviders().getMetaAccess());
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected void clearState() {
        super.clearState();
        this.hostedCallMethods = null;
    }

    protected GraalTruffleRuntime.CallMethods getCallMethods() {
        if (SubstrateUtil.HOSTED) {
            return this.hostedCallMethods;
        }
        return this.callMethods;
    }

    public OptimizedCallTarget createOptimizedCallTarget(OptimizedCallTarget source, RootNode rootNode) {
        CompilerAsserts.neverPartOfCompilation();
        if (!SubstrateUtil.HOSTED && !this.initialized) {
            this.initializeAtRuntime();
            this.initialized = true;
        }
        return TruffleFeature.getSupport().createOptimizedCallTarget(source, rootNode);
    }

    public SpeculationLog createSpeculationLog() {
        return new SubstrateSpeculationLog();
    }

    public void notifyTransferToInterpreter() {
        CompilerAsserts.neverPartOfCompilation();
    }

    public CancellableCompileTask submitForCompilation(OptimizedCallTarget optimizedCallTarget, boolean lastTierCompilation) {
        block4: {
            if (SubstrateUtil.HOSTED) {
                return null;
            }
            if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
                return super.submitForCompilation(optimizedCallTarget, lastTierCompilation);
            }
            try {
                this.doCompile(TruffleRuntimeOptions.getOptions(), optimizedCallTarget, null);
            }
            catch (OptimizationFailedException e) {
                if (!((Boolean)TruffleRuntimeOptions.getValue((org.graalvm.options.OptionKey)SharedTruffleRuntimeOptions.TruffleCompilationExceptionsArePrinted)).booleanValue()) break block4;
                Log.log().string(this.printStackTraceToString(e));
            }
        }
        return null;
    }

    public void finishCompilation(OptimizedCallTarget optimizedCallTarget, CancellableCompileTask task, boolean mayBeAsynchronous) {
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            super.finishCompilation(optimizedCallTarget, task, mayBeAsynchronous);
        }
    }

    public boolean cancelInstalledTask(OptimizedCallTarget optimizedCallTarget, Object source, CharSequence reason) {
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            return super.cancelInstalledTask(optimizedCallTarget, source, reason);
        }
        return false;
    }

    public void waitForCompilation(OptimizedCallTarget optimizedCallTarget, long timeout) throws ExecutionException, TimeoutException {
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            super.waitForCompilation(optimizedCallTarget, timeout);
            return;
        }
    }

    public boolean isCompiling(OptimizedCallTarget optimizedCallTarget) {
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            return super.isCompiling(optimizedCallTarget);
        }
        return false;
    }

    protected StackIntrospection getStackIntrospection() {
        return SubstrateStackIntrospection.SINGLETON;
    }

    public <T> T getOptions(Class<T> type) {
        if (type == OptionValues.class) {
            return type.cast((Object)RuntimeOptionValues.singleton());
        }
        return (T)super.getOptions(type);
    }

    public <T> T convertOptions(Class<T> type, Map<String, Object> map) {
        if (type == OptionValues.class) {
            EconomicMap values = OptionValues.newOptionMap();
            for (Map.Entry<String, Object> e : map.entrySet()) {
                String optionName = e.getKey();
                Object optionValue = e.getValue();
                Optional<OptionDescriptor> descriptor = RuntimeOptionParser.singleton().getDescriptor(optionName);
                if (!descriptor.isPresent()) continue;
                OptionDescriptor desc = descriptor.get();
                Class<?> valueType = optionValue.getClass();
                if (desc.getOptionValueType().isAssignableFrom(valueType)) {
                    values.put((Object)desc.getOptionKey(), optionValue);
                    continue;
                }
                throw new IllegalArgumentException("Invalid type of option '" + optionName + "': required " + desc.getOptionValueType().getSimpleName() + ", got " + valueType);
            }
            return type.cast(new OptionValues((UnmodifiableEconomicMap)values));
        }
        return (T)super.convertOptions(type, map);
    }

    protected Map<String, Object> createInitialOptions() {
        HashMap<String, Object> res = new HashMap<String, Object>();
        UnmodifiableMapCursor optionValues = RuntimeOptionValues.singleton().getMap().getEntries();
        while (optionValues.advance()) {
            OptionKey key = (OptionKey)optionValues.getKey();
            Object value = optionValues.getValue();
            res.put(key.getName(), value);
        }
        return res;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void resetNativeImageState() {
        this.clearState();
    }

    protected <T> T asObject(Class<T> type, JavaConstant constant) {
        GraalRuntime graalRuntime = this.graalRuntimeProvider.get();
        SnippetReflectionProvider snippetReflection = (SnippetReflectionProvider)graalRuntime.getRequiredCapability(SnippetReflectionProvider.class);
        return (T)snippetReflection.asObject(type, constant);
    }

    protected JavaConstant forObject(Object object) {
        GraalRuntime graalRuntime = this.graalRuntimeProvider.get();
        SnippetReflectionProvider snippetReflection = (SnippetReflectionProvider)graalRuntime.getRequiredCapability(SnippetReflectionProvider.class);
        return snippetReflection.forObject(object);
    }

    public void log(String message) {
        TTY.println((String)message);
    }
}

