/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.annotate.UnknownObjectField;
import com.oracle.svm.core.code.AbstractCodeInfo;
import com.oracle.svm.core.code.InstalledCodeObserver;
import com.oracle.svm.core.deopt.SubstrateInstalledCode;
import com.oracle.svm.core.heap.ObjectReferenceWalker;
import com.oracle.svm.core.heap.PinnedAllocator;
import com.oracle.svm.core.os.CommittedMemoryProvider;
import com.oracle.svm.core.util.VMError;
import java.lang.ref.WeakReference;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public final class RuntimeMethodInfo
extends AbstractCodeInfo {
    @UnknownObjectField(types={int[].class})
    protected int[] deoptimizationStartOffsets;
    @UnknownObjectField(types={byte[].class})
    protected byte[] deoptimizationEncodings;
    @UnknownObjectField(types={Object[].class})
    protected Object[] deoptimizationObjectConstants;
    protected String name;
    protected int tier;
    protected WeakReference<SubstrateInstalledCode> installedCode;
    protected ObjectReferenceWalker constantsWalker;
    protected PinnedAllocator allocator;
    protected InstalledCodeObserver.InstalledCodeObserverHandle[] codeObserverHandles;

    @Override
    public String getName() {
        return this.name;
    }

    public int getTier() {
        return this.tier;
    }

    private RuntimeMethodInfo() {
        throw VMError.shouldNotReachHere("Must be allocated with PinnedAllocator");
    }

    public void setData(CodePointer codeStart, UnsignedWord codeSize, SubstrateInstalledCode installedCode, int tier, ObjectReferenceWalker constantsWalker, PinnedAllocator allocator, InstalledCodeObserver.InstalledCodeObserverHandle[] codeObserverHandles) {
        super.setData(codeStart, codeSize);
        this.name = installedCode.getName();
        this.installedCode = RuntimeMethodInfo.createInstalledCodeReference(installedCode);
        this.tier = tier;
        this.constantsWalker = constantsWalker;
        this.allocator = allocator;
        assert (codeObserverHandles != null);
        this.codeObserverHandles = codeObserverHandles;
    }

    private static WeakReference<SubstrateInstalledCode> createInstalledCodeReference(SubstrateInstalledCode installedCode) {
        return new WeakReference<SubstrateInstalledCode>(installedCode);
    }

    @Uninterruptible(reason="Called from uninterruptible code", mayBeInlined=true)
    void freeInstalledCode() {
        CommittedMemoryProvider.get().free((PointerBase)this.getCodeStart(), this.getCodeSize(), WordFactory.unsigned((int)SubstrateOptions.codeAlignment()), true);
    }
}

