/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.stack.StackFrameVisitor;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;

public class FramePointerMapWalker
implements StackFrameVisitor {
    private final ObjectReferenceVisitor visitor;

    public static FramePointerMapWalker factory(ObjectReferenceVisitor objRefVisitor) {
        return new FramePointerMapWalker(objRefVisitor);
    }

    @Override
    public boolean prologue() {
        return this.visitor.prologue();
    }

    @Override
    public boolean visitFrame(Pointer sp, CodePointer ip, DeoptimizedFrame deoptimizedFrame) {
        return CodeInfoTable.visitObjectReferences(sp, ip, deoptimizedFrame, this.visitor);
    }

    @Override
    public boolean epilogue() {
        return this.visitor.epilogue();
    }

    protected FramePointerMapWalker(ObjectReferenceVisitor objRefVisitor) {
        this.visitor = objRefVisitor;
    }
}

