/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.jdk.JNIRegistrationUtil;
import com.oracle.svm.core.jni.JNIRuntimeAccess;
import java.lang.reflect.Executable;
import java.net.DatagramPacket;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CLibrary;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.graalvm.nativeimage.impl.InternalPlatform;

@Platforms(value={InternalPlatform.PLATFORM_JNI.class})
@CLibrary(value="net", requireStatic=true)
@AutomaticFeature
class JNIRegistrationJavaNet
extends JNIRegistrationUtil
implements Feature {
    JNIRegistrationJavaNet() {
    }

    public void duringSetup(Feature.DuringSetupAccess a) {
        JNIRegistrationJavaNet.rerunClassInit((Feature.FeatureAccess)a, "java.net.NetworkInterface", "java.net.DefaultInterface", "java.net.InetAddress", "java.net.Inet4AddressImpl", "java.net.Inet6AddressImpl", "java.net.SocketInputStream", "java.net.SocketOutputStream", "java.net.DatagramPacket", "java.net.AbstractPlainSocketImpl", "java.net.AbstractPlainDatagramSocketImpl");
        if (JNIRegistrationJavaNet.isPosix()) {
            JNIRegistrationJavaNet.rerunClassInit((Feature.FeatureAccess)a, "java.net.PlainSocketImpl", "java.net.PlainDatagramSocketImpl");
            if (JavaVersionUtil.JAVA_SPEC <= 8) {
                JNIRegistrationJavaNet.rerunClassInit((Feature.FeatureAccess)a, "sun.net.ExtendedOptionsImpl");
            }
        }
        if (JNIRegistrationJavaNet.isWindows()) {
            JNIRegistrationJavaNet.rerunClassInit((Feature.FeatureAccess)a, "java.net.DualStackPlainSocketImpl", "java.net.TwoStacksPlainSocketImpl", "java.net.DualStackPlainDatagramSocketImpl", "java.net.TwoStacksPlainDatagramSocketImpl");
        }
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess a) {
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.clazz((Feature.FeatureAccess)a, "java.net.SocketException"));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.constructor((Feature.FeatureAccess)a, "java.net.SocketException", String.class));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.clazz((Feature.FeatureAccess)a, "java.net.ConnectException"));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.constructor((Feature.FeatureAccess)a, "java.net.ConnectException", String.class));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.clazz((Feature.FeatureAccess)a, "java.net.BindException"));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.constructor((Feature.FeatureAccess)a, "java.net.BindException", String.class));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.clazz((Feature.FeatureAccess)a, "java.net.UnknownHostException"));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.constructor((Feature.FeatureAccess)a, "java.net.UnknownHostException", String.class));
        a.registerReachabilityHandler(JNIRegistrationJavaNet::registerInitInetAddressIDs, new Object[]{JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "java.net.InetAddress", "init", new Class[0]), JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "java.net.Inet4Address", "init", new Class[0]), JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "java.net.Inet6Address", "init", new Class[0]), JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "java.net.NetworkInterface", "init", new Class[0]), JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "sun.nio.ch.IOUtil", "initIDs", new Class[0]), JNIRegistrationJavaNet.clazz((Feature.FeatureAccess)a, "java.net.Inet4AddressImpl"), JNIRegistrationJavaNet.clazz((Feature.FeatureAccess)a, "java.net.Inet6AddressImpl")});
        if (JNIRegistrationJavaNet.isPosix()) {
            a.registerReachabilityHandler(JNIRegistrationJavaNet::registerInitInetAddressIDs, new Object[]{JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "java.net.PlainSocketImpl", "initProto", new Class[0]), JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "java.net.PlainDatagramSocketImpl", "init", new Class[0])});
        }
        if (JNIRegistrationJavaNet.isWindows()) {
            a.registerReachabilityHandler(JNIRegistrationJavaNet::registerInitInetAddressIDs, new Object[]{JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "java.net.DualStackPlainSocketImpl", "initIDs", new Class[0]), JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "java.net.DualStackPlainDatagramSocketImpl", "initIDs", new Class[0])});
        }
        a.registerReachabilityHandler(JNIRegistrationJavaNet::registerNetworkInterfaceInit, new Object[]{JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "java.net.NetworkInterface", "init", new Class[0])});
        a.registerReachabilityHandler(JNIRegistrationJavaNet::registerDatagramPacketInit, new Object[]{JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "java.net.DatagramPacket", "init", new Class[0])});
        if (JNIRegistrationJavaNet.isPosix()) {
            a.registerReachabilityHandler(JNIRegistrationJavaNet::registerPlainDatagramSocketImplInit, new Object[]{JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "java.net.PlainDatagramSocketImpl", "init", new Class[0])});
            a.registerReachabilityHandler(JNIRegistrationJavaNet::registerNetworkInterfaceInit, new Object[]{JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "java.net.PlainDatagramSocketImpl", "init", new Class[0])});
            a.registerReachabilityHandler(JNIRegistrationJavaNet::registerPlainSocketImplInitProto, new Object[]{JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "java.net.PlainSocketImpl", "initProto", new Class[0])});
            a.registerReachabilityHandler(JNIRegistrationJavaNet::registerExtendedOptionsImplInit, new Object[]{JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "sun.net.ExtendedOptionsImpl", "init", new Class[0])});
        }
    }

    private static void registerInitInetAddressIDs(Feature.DuringAnalysisAccess a) {
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.clazz((Feature.FeatureAccess)a, "java.net.InetAddress"));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.InetAddress", "holder", "preferIPv6Address"));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.clazz((Feature.FeatureAccess)a, "java.net.InetAddress$InetAddressHolder"));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.InetAddress$InetAddressHolder", "address", "family", "hostName", "originalHostName"));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.clazz((Feature.FeatureAccess)a, "java.net.Inet4Address"));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.constructor((Feature.FeatureAccess)a, "java.net.Inet4Address", new Class[0]));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.clazz((Feature.FeatureAccess)a, "java.net.Inet6Address"));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.constructor((Feature.FeatureAccess)a, "java.net.Inet6Address", new Class[0]));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.Inet6Address", "holder6"));
        if (JavaVersionUtil.JAVA_SPEC <= 11) {
            JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.Inet6Address", "cached_scope_id"));
        }
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.clazz((Feature.FeatureAccess)a, "java.net.Inet6Address$Inet6AddressHolder"));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.Inet6Address$Inet6AddressHolder", "ipaddress", "scope_id", "scope_id_set", "scope_ifname"));
    }

    private static void registerNetworkInterfaceInit(Feature.DuringAnalysisAccess a) {
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.clazz((Feature.FeatureAccess)a, "java.net.NetworkInterface"));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.constructor((Feature.FeatureAccess)a, "java.net.NetworkInterface", new Class[0]));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.NetworkInterface", "name", "displayName", "index", "addrs", "bindings", "childs"));
        if (JNIRegistrationJavaNet.isPosix()) {
            JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.NetworkInterface", "virtual", "parent", "defaultIndex"));
        }
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.clazz((Feature.FeatureAccess)a, "java.net.InterfaceAddress"));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.constructor((Feature.FeatureAccess)a, "java.net.InterfaceAddress", new Class[0]));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.InterfaceAddress", "address", "broadcast", "maskLength"));
    }

    private static void registerDatagramPacketInit(Feature.DuringAnalysisAccess a) {
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.DatagramPacket", "address", "port", "buf", "offset", "length", "bufLength"));
    }

    private static void registerPlainDatagramSocketImplInit(Feature.DuringAnalysisAccess a) {
        RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "java.net.PlainDatagramSocketImpl", "peekData", DatagramPacket.class)});
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.AbstractPlainDatagramSocketImpl", "timeout", "trafficClass", "connected", "connectedAddress", "connectedPort"));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.DatagramSocketImpl", "fd", "localPort"));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.clazz((Feature.FeatureAccess)a, "java.lang.Integer"));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.constructor((Feature.FeatureAccess)a, "java.lang.Integer", Integer.TYPE));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.clazz((Feature.FeatureAccess)a, "java.lang.Boolean"));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.constructor((Feature.FeatureAccess)a, "java.lang.Boolean", Boolean.TYPE));
    }

    private static void registerPlainSocketImplInitProto(Feature.DuringAnalysisAccess a) {
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.SocketImpl", "fd", "address", "port", "localport", "serverSocket"));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.AbstractPlainSocketImpl", "timeout", "trafficClass"));
        if (JNIRegistrationJavaNet.isPosix()) {
            JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.AbstractPlainSocketImpl", "fdLock", "closePending"));
        }
    }

    private static void registerExtendedOptionsImplInit(Feature.DuringAnalysisAccess a) {
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.clazz((Feature.FeatureAccess)a, "jdk.net.SocketFlow"));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "jdk.net.SocketFlow", "status", "priority", "bandwidth"));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.clazz((Feature.FeatureAccess)a, "jdk.net.SocketFlow$Status"));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "jdk.net.SocketFlow$Status", "NO_STATUS", "OK", "NO_PERMISSION", "NOT_CONNECTED", "NOT_SUPPORTED", "ALREADY_CREATED", "IN_PROGRESS", "OTHER"));
    }
}

