/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.jdk.LocalizationResourceBundles;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.OptionUtils;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class LocalizationSupport {
    protected final Map<String, Charset> charsets;
    protected final Map<String, ResourceBundle> cache;
    private final String includeResourceBundlesOption = SubstrateOptionsParser.commandArgument(Options.IncludeResourceBundles, "");

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public LocalizationSupport() {
        this.charsets = new HashMap<String, Charset>();
        this.cache = new HashMap<String, ResourceBundle>();
        LocalizationResourceBundles.initialize(this);
        this.includeResourceBundles();
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void addBundleToCache(String bundleName) {
        if (bundleName.isEmpty()) {
            return;
        }
        ResourceBundle bundle = this.getBundleInDefaultLocale(bundleName);
        this.addBundleToCache(bundleName, bundle);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    ResourceBundle getBundleInDefaultLocale(String bundleName) {
        ResourceBundle result = ResourceBundle.getBundle(bundleName, Locale.getDefault(), Thread.currentThread().getContextClassLoader());
        return result;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    void addBundleToCache(String bundleName, ResourceBundle bundle) {
        bundle.keySet();
        this.cache.put(bundleName, bundle);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    void includeResourceBundles() {
        for (String bundle : OptionUtils.flatten(",", Options.IncludeResourceBundles.getValue())) {
            this.addBundleToCache(bundle);
        }
    }

    public ResourceBundle getCached(String baseName, Locale locale) throws MissingResourceException {
        ResourceBundle result = this.cache.get(baseName);
        if (result == null) {
            String errorMessage = "Resource bundle not found " + baseName + ". Register the resource bundle using the option " + this.includeResourceBundlesOption + baseName + ".";
            throw new MissingResourceException(errorMessage, this.getClass().getName(), baseName);
        }
        return result;
    }

    public static class Options {
        @Option(help={"Comma separated list of bundles to be included into the image."}, type=OptionType.User)
        public static final HostedOptionKey<String[]> IncludeResourceBundles = new HostedOptionKey<Object>(null);
    }
}

