/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.JDK8OrEarlier;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.headers.Fcntl;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@TargetClass(value=FileOutputStream.class)
@Platforms(value={Platform.LINUX.class, Platform.DARWIN.class})
final class Target_java_io_FileOutputStream {
    Target_java_io_FileOutputStream() {
    }

    @Substitute
    protected void writeBytes(byte[] bytes, int off, int len, boolean append) throws IOException {
        PosixUtils.writeBytes(SubstrateUtil.getFileDescriptor(SubstrateUtil.cast(this, FileOutputStream.class)), bytes, off, len, append);
    }

    @Substitute
    private void open(String name, boolean append) throws FileNotFoundException {
        PosixUtils.fileOpen(name, SubstrateUtil.getFileDescriptor(SubstrateUtil.cast(this, FileOutputStream.class)), Fcntl.O_WRONLY() | Fcntl.O_CREAT() | (append ? Fcntl.O_APPEND() : Fcntl.O_TRUNC()));
    }

    @Substitute
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private void close0() throws IOException {
        PosixUtils.fileClose(SubstrateUtil.getFileDescriptor(SubstrateUtil.cast(this, FileOutputStream.class)));
    }

    @Substitute
    private void write(int b, boolean append) throws IOException {
        PosixUtils.writeSingle(SubstrateUtil.getFileDescriptor(SubstrateUtil.cast(this, FileOutputStream.class)), b, append);
    }
}

