/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.darwin;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.posix.headers.Pthread;
import com.oracle.svm.core.posix.headers.darwin.DarwinPthread;
import com.oracle.svm.core.stack.StackOverflowCheck;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.impl.InternalPlatform;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

@Platforms(value={InternalPlatform.DARWIN_AND_JNI.class})
class DarwinStackOverflowSupport
implements StackOverflowCheck.OSSupport {
    DarwinStackOverflowSupport() {
    }

    @Override
    @Uninterruptible(reason="Called while thread is being attached to the VM, i.e., when the thread state is not yet set up.")
    public UnsignedWord lookupStackEnd() {
        Pthread.pthread_t self = Pthread.pthread_self();
        Pointer stackaddr = DarwinPthread.pthread_get_stackaddr_np(self);
        UnsignedWord stacksize = DarwinPthread.pthread_get_stacksize_np(self);
        return stackaddr.subtract(stacksize);
    }
}

