/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.agent;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.NativeImageClassLoader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class ClassInitializationTrackingVisitor
extends ClassVisitor {
    private final ClassLoader loader;
    private final String className;
    private String moduleName;
    private boolean hasClinit;
    private boolean ldcClassLiteralSupported;
    private static Set<String> trackedJDKClasses = new HashSet<String>(Arrays.asList("java.lang.Thread", "java.util.zip.ZipFile", "java.nio.MappedByteBuffer", "java.io.FileDescriptor"));

    public ClassInitializationTrackingVisitor(String moduleName, ClassLoader loader, String className, ClassWriter writer) {
        super(393216, writer);
        this.moduleName = moduleName;
        this.hasClinit = false;
        this.loader = loader;
        this.className = className;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.ldcClassLiteralSupported = (version & 0xFFFF) >= 51;
    }

    @Override
    public void visitEnd() {
        if (!this.hasClinit && this.instrumentationSupported() && this.clinitInstrumentationSupported()) {
            MethodVisitor mv = this.visitMethod(8, "<clinit>", "()V", null, null);
            mv.visitCode();
            mv.visitInsn(177);
            mv.visitMaxs(1, 0);
            mv.visitEnd();
        }
        super.visitEnd();
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor methodVisitor = super.visitMethod(access, name, desc, signature, exceptions);
        boolean isClinitMethod = "<clinit>".equals(name);
        boolean bl = this.hasClinit = this.hasClinit || isClinitMethod;
        if (this.instrumentationSupported()) {
            if (isClinitMethod && this.clinitInstrumentationSupported()) {
                return new ClassInitializerMethod(methodVisitor);
            }
            if (this.initInstrumentationSupported(name)) {
                return new ClassConstructorMethod(methodVisitor);
            }
            return methodVisitor;
        }
        return methodVisitor;
    }

    private boolean clinitInstrumentationSupported() {
        return this.ldcClassLiteralSupported;
    }

    private static int getJavaVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2, 3);
        } else {
            int dot = version.indexOf(".");
            if (dot != -1) {
                version = version.substring(0, dot);
            }
        }
        return Integer.parseInt(version);
    }

    private boolean initInstrumentationSupported(String name) {
        if (!"<init>".equals(name)) {
            return false;
        }
        if (ClassInitializationTrackingVisitor.getJavaVersion() > 8) {
            return false;
        }
        if (this.loader instanceof NativeImageClassLoader) {
            return true;
        }
        if (trackedJDKClasses.contains(this.className)) {
            return true;
        }
        return this.className.contains("java/nio") && this.className.contains("Buffer");
    }

    private boolean instrumentationSupported() {
        if (ClassInitializationTrackingVisitor.getJavaVersion() == 8) {
            return this.loader != null && this.className != null && !this.className.startsWith("sun/reflect/Generated");
        }
        if (ClassInitializationTrackingVisitor.getJavaVersion() > 8) {
            return this.moduleName != null && !this.moduleName.startsWith("java.") && !this.moduleName.startsWith("jdk.");
        }
        throw VMError.shouldNotReachHere();
    }

    private static String toInternalName(String className) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('L');
        int nameLength = className.length();
        for (int i = 0; i < nameLength; ++i) {
            char car = className.charAt(i);
            stringBuilder.append(car == '.' ? (char)'/' : (char)car);
        }
        stringBuilder.append(';');
        return stringBuilder.toString();
    }

    private static void guardedTrackingCall(MethodVisitor mv, String methodName, Runnable pushOperands, String descriptor) {
        String trackingClass = "org/graalvm/nativeimage/impl/clinit/ClassInitializationTracking";
        mv.visitFieldInsn(178, trackingClass, "IS_IMAGE_BUILD_TIME", "Z");
        Label l1 = new Label();
        mv.visitJumpInsn(153, l1);
        pushOperands.run();
        mv.visitMethodInsn(184, trackingClass, methodName, descriptor, false);
        mv.visitLabel(l1);
    }

    public class ClassConstructorMethod
    extends MethodVisitor {
        ClassConstructorMethod(MethodVisitor methodVisitor) {
            super(393216, methodVisitor);
        }

        @Override
        public void visitInsn(int opcode) {
            assert (opcode != 176 && opcode != 172 && opcode != 174 && opcode != 173 && opcode != 175) : "Constructor can only return void";
            if (opcode == 177) {
                ClassInitializationTrackingVisitor.guardedTrackingCall(this.mv, "reportObjectInstantiated", () -> this.mv.visitVarInsn(25, 0), "(Ljava/lang/Object;)V");
            }
            super.visitInsn(opcode);
        }

        @Override
        public void visitMaxs(int maxStack, int maxLocals) {
            super.visitMaxs(maxStack == 0 ? 1 : maxStack, maxLocals);
        }
    }

    public class ClassInitializerMethod
    extends MethodVisitor {
        ClassInitializerMethod(MethodVisitor methodVisitor) {
            super(393216, methodVisitor);
        }

        @Override
        public void visitCode() {
            ClassInitializationTrackingVisitor.guardedTrackingCall(this.mv, "reportClassInitialized", () -> this.mv.visitLdcInsn(Type.getType(ClassInitializationTrackingVisitor.toInternalName(ClassInitializationTrackingVisitor.this.className))), "(Ljava/lang/Class;)V");
            this.mv.visitCode();
        }

        @Override
        public void visitMaxs(int maxStack, int maxLocals) {
            super.visitMaxs(maxStack == 0 ? 1 : maxStack, maxLocals);
        }
    }
}

