/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.option;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.option.APIOption;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.util.InterruptImageBuilding;
import com.oracle.svm.core.util.VMError;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.core.CompilationWrapper;
import org.graalvm.compiler.debug.DebugOptions;
import org.graalvm.compiler.options.OptionDescriptor;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.compiler.options.OptionsParser;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class SubstrateOptionsParser {
    public static final String HOSTED_OPTION_PREFIX = "-H:";
    public static final String RUNTIME_OPTION_PREFIX = "-R:";

    static OptionParseResult parseOption(SortedMap<String, OptionDescriptor> options, String option, EconomicMap<OptionKey<?>, Object> valuesMap, String optionPrefix, BooleanOptionFormat booleanOptionFormat) {
        String optionName;
        if (option.length() == 0) {
            return OptionParseResult.error("Option name must be specified");
        }
        Object[] value = null;
        String valueString = null;
        char first = option.charAt(0);
        int eqIndex = option.indexOf(61);
        if (first == '+' || first == '-') {
            if (eqIndex != -1) {
                return OptionParseResult.error("Cannot mix +/- with <name>=<value> format: '" + optionPrefix + option + "'");
            }
            optionName = option.substring(1, option.length());
            if (booleanOptionFormat == BooleanOptionFormat.NAME_VALUE) {
                return OptionParseResult.error("Option '" + optionName + "' must use <name>=<value> format, not +/- prefix");
            }
            value = first == '+';
        } else if (eqIndex == -1) {
            optionName = option;
            valueString = null;
        } else {
            optionName = option.substring(0, eqIndex);
            valueString = option.substring(eqIndex + 1);
        }
        OptionDescriptor desc = (OptionDescriptor)options.get(optionName);
        if (desc == null && value != null && eqIndex != -1) {
            optionName = option.substring(1, eqIndex);
            desc = (OptionDescriptor)options.get(optionName);
        }
        if (desc == null) {
            ArrayList matches = new ArrayList();
            OptionsParser.collectFuzzyMatches(options.values(), (String)optionName, matches);
            StringBuilder msg = new StringBuilder("Could not find option '").append(optionName).append('\'');
            if (!matches.isEmpty()) {
                msg.append(". Did you mean one of these:");
                for (OptionDescriptor match : matches) {
                    msg.append(' ').append(match.getName());
                }
            }
            msg.append(". Use " + optionPrefix + SubstrateOptions.PrintFlags.getName() + "= to list all available options.");
            return OptionParseResult.error(msg.toString());
        }
        Class optionType = desc.getOptionValueType();
        if (value == null) {
            if (optionType == Boolean.class && booleanOptionFormat == BooleanOptionFormat.PLUS_MINUS) {
                return OptionParseResult.error("Boolean option '" + optionName + "' must have +/- prefix");
            }
            if (valueString == null) {
                return OptionParseResult.error("Missing value for option '" + optionName + "'");
            }
            try {
                if (optionType.isArray()) {
                    OptionKey optionKey = desc.getOptionKey();
                    Object addValue = SubstrateOptionsParser.parseValue(optionType.getComponentType(), optionName, valueString);
                    Object previous = valuesMap.get((Object)optionKey);
                    if (previous == null) {
                        value = Array.newInstance(optionType.getComponentType(), 1);
                        ((Object[])value)[0] = addValue;
                    }
                    Object[] previousValues = (Object[])previous;
                    value = Arrays.copyOf(previousValues, previousValues.length + 1);
                    value[previousValues.length] = addValue;
                }
                value = SubstrateOptionsParser.parseValue(optionType, optionName, valueString);
            }
            catch (NumberFormatException ex) {
                return OptionParseResult.error("Invalid value for option '" + optionName + "': '" + valueString + "' is not a valid number");
            }
        } else if (optionType != Boolean.class) {
            return OptionParseResult.error("Non-boolean option '" + optionName + "' can not use +/- prefix. Use '" + optionName + "=<value>' format");
        }
        desc.getOptionKey().update(valuesMap, (Object)value);
        if (SubstrateOptions.PrintFlags.getName().equals(optionName)) {
            EnumSet<OptionType> selectedOptionTypes;
            String optionValue = (String)value;
            if (optionValue.isEmpty()) {
                selectedOptionTypes = EnumSet.allOf(OptionType.class);
            } else {
                selectedOptionTypes = EnumSet.noneOf(OptionType.class);
                String enumString = null;
                try {
                    String[] enumStrings = SubstrateUtil.split(optionValue, ",");
                    for (int i = 0; i < enumStrings.length; ++i) {
                        enumString = enumStrings[i];
                        selectedOptionTypes.add(OptionType.valueOf((String)enumString));
                    }
                }
                catch (IllegalArgumentException e) {
                    StringBuilder sb = new StringBuilder();
                    boolean firstValue = true;
                    for (OptionType ot : OptionType.values()) {
                        if (firstValue) {
                            firstValue = false;
                        } else {
                            sb.append(", ");
                        }
                        sb.append(ot.name());
                    }
                    String possibleValues = sb.toString();
                    return OptionParseResult.error("Invalid value for option '" + optionName + ". " + enumString + "' is not one of: " + possibleValues);
                }
            }
            return OptionParseResult.printFlags(selectedOptionTypes);
        }
        return OptionParseResult.correct();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Object parseValue(Class<?> optionType, String optionName, String valueString) throws NumberFormatException {
        if (optionType == Integer.class) {
            long longValue = SubstrateOptionsParser.parseLong(valueString);
            if ((long)((int)longValue) == longValue) return (int)longValue;
            return OptionParseResult.error("Wrong value for option '" + optionName + "': '" + valueString + "' is not a valid number");
        }
        if (optionType == Long.class) {
            return SubstrateOptionsParser.parseLong(valueString);
        }
        if (optionType == String.class) {
            return valueString;
        }
        if (optionType == Double.class) {
            return SubstrateOptionsParser.parseDouble(valueString);
        }
        if (optionType == Boolean.class) {
            if (valueString.equals("true")) {
                return true;
            }
            if (!valueString.equals("false")) return OptionParseResult.error("Boolean option '" + optionName + "' must have value 'true' or 'false'");
            return false;
        }
        if (optionType == CompilationWrapper.ExceptionAction.class) {
            return CompilationWrapper.ExceptionAction.valueOf((String)valueString);
        }
        if (optionType != DebugOptions.PrintGraphTarget.class) throw VMError.shouldNotReachHere("Unsupported option value class: " + optionType.getSimpleName());
        return DebugOptions.PrintGraphTarget.valueOf((String)valueString);
    }

    public static boolean parseHostedOption(String optionPrefix, SortedMap<String, OptionDescriptor> options, EconomicMap<OptionKey<?>, Object> valuesMap, BooleanOptionFormat booleanOptionFormat, Set<String> errors, String arg, PrintStream out) {
        if (!arg.startsWith(optionPrefix)) {
            return false;
        }
        OptionParseResult optionParseResult = SubstrateOptionsParser.parseOption(options, arg.substring(optionPrefix.length()), valuesMap, optionPrefix, booleanOptionFormat);
        if (optionParseResult.printFlags()) {
            SubstrateOptionsParser.printFlags(optionParseResult::matchesFlagsHosted, options, optionPrefix, out);
            throw new InterruptImageBuilding();
        }
        if (!optionParseResult.isValid()) {
            errors.add(optionParseResult.getError());
        }
        return true;
    }

    private static String spaces(int length) {
        return new String(new char[length]).replace('\u0000', ' ');
    }

    private static String wrap(String s, int width) {
        StringBuilder sb = new StringBuilder(s);
        int cursor = 0;
        while (cursor + width < sb.length()) {
            int i = sb.lastIndexOf(" ", cursor + width);
            if (i == -1 || i < cursor) {
                i = sb.indexOf(" ", cursor + width);
            }
            if (i == -1) break;
            sb.replace(i, i + 1, System.lineSeparator());
            cursor = i;
        }
        return sb.toString();
    }

    private static void printOption(PrintStream out, String option, String description) {
        SubstrateOptionsParser.printOption(out::println, option, description, 2, 45, 120);
    }

    public static void printOption(Consumer<String> println, String option, String description, int indentation, int optionWidth, int wrapWidth) {
        String indent = SubstrateOptionsParser.spaces(indentation);
        String desc = SubstrateOptionsParser.wrap(description != null ? description : "", wrapWidth);
        String nl = System.lineSeparator();
        String[] descLines = SubstrateUtil.split(desc, nl);
        if (option.length() >= optionWidth && description != null) {
            println.accept(indent + option + nl + indent + SubstrateOptionsParser.spaces(optionWidth) + descLines[0]);
        } else {
            println.accept(indent + option + SubstrateOptionsParser.spaces(optionWidth - option.length()) + descLines[0]);
        }
        for (int i = 1; i < descLines.length; ++i) {
            println.accept(indent + SubstrateOptionsParser.spaces(optionWidth) + descLines[i]);
        }
    }

    static void printFlags(Predicate<OptionDescriptor> filter, SortedMap<String, OptionDescriptor> sortedOptions, String prefix, PrintStream out) {
        for (Map.Entry<String, OptionDescriptor> entry : sortedOptions.entrySet()) {
            OptionDescriptor descriptor = entry.getValue();
            if (!filter.test(descriptor)) continue;
            String helpMsg = descriptor.getHelp();
            int helpLen = helpMsg.length();
            if (helpLen > 0 && helpMsg.charAt(helpLen - 1) != '.') {
                helpMsg = helpMsg + '.';
            }
            boolean stringifiedArrayValue = false;
            Object defaultValue = descriptor.getOptionKey().getDefaultValue();
            if (defaultValue != null && defaultValue.getClass().isArray()) {
                Object[] defaultValues = (Object[])defaultValue;
                if (defaultValues.length == 1) {
                    defaultValue = defaultValues[0];
                } else {
                    ArrayList<String> stringList = new ArrayList<String>();
                    String optionPrefix = prefix + entry.getKey() + "=";
                    for (Object rawValue : defaultValues) {
                        String value = rawValue instanceof String ? '\"' + String.valueOf(rawValue) + '\"' : String.valueOf(rawValue);
                        stringList.add(optionPrefix + value);
                    }
                    if (helpLen != 0) {
                        helpMsg = helpMsg + ' ';
                    }
                    helpMsg = helpMsg + "Default: ";
                    helpMsg = stringList.isEmpty() ? helpMsg + "None" : helpMsg + String.join((CharSequence)" ", stringList);
                    stringifiedArrayValue = true;
                }
            }
            if (descriptor.getOptionValueType() == Boolean.class) {
                Boolean val = (Boolean)defaultValue;
                if (helpLen != 0) {
                    helpMsg = helpMsg + ' ';
                }
                if (val != null) {
                    helpMsg = val != false ? helpMsg + "Default: + (enabled)." : helpMsg + "Default: - (disabled).";
                }
                SubstrateOptionsParser.printOption(out, prefix + "\u00b1" + entry.getKey(), helpMsg);
                continue;
            }
            if (defaultValue == null) {
                if (helpLen != 0) {
                    helpMsg = helpMsg + ' ';
                }
                helpMsg = helpMsg + "Default: None";
            }
            if (stringifiedArrayValue || defaultValue == null) {
                SubstrateOptionsParser.printOption(out, prefix + entry.getKey() + "=...", helpMsg);
                continue;
            }
            if (defaultValue instanceof String) {
                defaultValue = '\"' + String.valueOf(defaultValue) + '\"';
            }
            SubstrateOptionsParser.printOption(out, prefix + entry.getKey() + "=" + defaultValue, helpMsg);
        }
    }

    public static long parseLong(String v) {
        String valueString = v.trim().toLowerCase();
        long scale = 1L;
        if (valueString.endsWith("k")) {
            scale = 1024L;
        } else if (valueString.endsWith("m")) {
            scale = 0x100000L;
        } else if (valueString.endsWith("g")) {
            scale = 0x40000000L;
        } else if (valueString.endsWith("t")) {
            scale = 0x10000000000L;
        }
        if (scale != 1L) {
            valueString = valueString.substring(0, valueString.length() - 1);
        }
        return Long.parseLong(valueString) * scale;
    }

    public static double parseDouble(String v) {
        String valueString = v.trim();
        int dotPos = valueString.indexOf(46);
        if (dotPos == -1) {
            return SubstrateOptionsParser.parseLong(valueString);
        }
        String beforeDot = valueString.substring(0, dotPos);
        String afterDot = valueString.substring(dotPos + 1);
        double sign = 1.0;
        if (beforeDot.startsWith("-")) {
            sign = -1.0;
            beforeDot = beforeDot.substring(1);
        } else if (beforeDot.startsWith("+")) {
            beforeDot = beforeDot.substring(1);
        }
        if (beforeDot.startsWith("-") || beforeDot.startsWith("+") || afterDot.startsWith("-") || afterDot.startsWith("+") || beforeDot.length() == 0 && afterDot.length() == 0) {
            throw new NumberFormatException(v);
        }
        double integral = 0.0;
        if (beforeDot.length() > 0) {
            integral = Long.parseLong(beforeDot);
        }
        double fraction = 0.0;
        if (afterDot.length() > 0) {
            fraction = (double)Long.parseLong(afterDot) * Math.pow(10.0, -afterDot.length());
        }
        return sign * (integral + fraction);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static String commandArgument(OptionKey<?> option, String value) {
        return SubstrateOptionsParser.commandArgument(option, value, null);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static String commandArgument(OptionKey<?> option, String value, String apiOptionName) {
        APIOption[] apiOptions;
        Field field;
        try {
            field = option.getDescriptor().getDeclaringClass().getDeclaredField(option.getDescriptor().getFieldName());
        }
        catch (ReflectiveOperationException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
        for (APIOption apiOption : apiOptions = (APIOption[])field.getAnnotationsByType(APIOption.class)) {
            assert (!apiOption.name().equals(apiOptionName) || apiOption.deprecated().equals("")) : "Using the deprecated option in a description: " + apiOption;
        }
        if (option.getDescriptor().getOptionValueType() == Boolean.class) {
            VMError.guarantee(value.equals("+") || value.equals("-"), "Boolean option value can be only + or -");
            for (APIOption apiOption : apiOptions) {
                String apiValue;
                String string = apiValue = apiOption.kind() == APIOption.APIOptionKind.Negated ? "-" : "+";
                if (!apiValue.equals(value)) continue;
                return APIOption.Utils.name(apiOption);
            }
            return HOSTED_OPTION_PREFIX + value + option;
        }
        for (APIOption apiOption : apiOptions) {
            String fixedValue;
            String string = fixedValue = apiOption.fixedValue().length == 0 ? null : apiOption.fixedValue()[0];
            if (!apiOption.name().equals(apiOptionName)) continue;
            if (fixedValue == null) {
                return APIOption.Utils.name(apiOption) + "=" + value;
            }
            if (!value.equals(fixedValue)) continue;
            return APIOption.Utils.name(apiOption);
        }
        assert (apiOptionName == null) : "invalid API option name " + apiOptionName;
        return HOSTED_OPTION_PREFIX + option.getName() + "=" + value;
    }

    public static enum BooleanOptionFormat {
        NAME_VALUE("<name>=<value>"),
        PLUS_MINUS("+/-<name>");

        private final String help;

        private BooleanOptionFormat(String help) {
            this.help = help;
        }

        public String toString() {
            return this.help;
        }
    }

    static final class OptionParseResult {
        private final EnumSet<OptionType> printFlags;
        private final String error;

        private OptionParseResult(EnumSet<OptionType> printFlags, String error) {
            this.printFlags = printFlags;
            this.error = error;
        }

        static OptionParseResult error(String message) {
            return new OptionParseResult(EnumSet.noneOf(OptionType.class), message);
        }

        static OptionParseResult correct() {
            return new OptionParseResult(EnumSet.noneOf(OptionType.class), null);
        }

        static OptionParseResult printFlags(EnumSet<OptionType> selectedOptionTypes) {
            return new OptionParseResult(selectedOptionTypes, null);
        }

        boolean printFlags() {
            return !this.printFlags.isEmpty();
        }

        public boolean isValid() {
            return this.printFlags.isEmpty() && this.error == null;
        }

        public String getError() {
            return this.error;
        }

        private boolean matchesFlags(OptionDescriptor d, boolean svmOption) {
            boolean showAll = this.printFlags.equals(EnumSet.allOf(OptionType.class));
            return showAll || svmOption && this.printFlags.contains(d.getOptionType());
        }

        boolean matchesFlagsRuntime(OptionDescriptor d) {
            return this.matchesFlags(d, d.getOptionKey() instanceof RuntimeOptionKey);
        }

        boolean matchesFlagsHosted(OptionDescriptor d) {
            OptionKey key = d.getOptionKey();
            return this.matchesFlags(d, key instanceof RuntimeOptionKey || key instanceof HostedOptionKey);
        }
    }
}

