/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.headers;

import com.oracle.svm.core.posix.headers.PosixDirectives;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.constant.CConstant;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.struct.CField;
import org.graalvm.nativeimage.c.struct.CFieldAddress;
import org.graalvm.nativeimage.c.struct.CPointerTo;
import org.graalvm.nativeimage.c.struct.CStruct;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.SignedWord;

@CContext(value=PosixDirectives.class)
public class Dirent {
    @CConstant
    public static native int DT_UNKNOWN();

    @CConstant
    public static native int DT_FIFO();

    @CConstant
    public static native int DT_CHR();

    @CConstant
    public static native int DT_DIR();

    @CConstant
    public static native int DT_BLK();

    @CConstant
    public static native int DT_REG();

    @CConstant
    public static native int DT_LNK();

    @CConstant
    public static native int DT_SOCK();

    @CConstant
    public static native int DT_WHT();

    @CFunction
    public static native DIR opendir(CCharPointer var0);

    @CFunction(value="fdopendir", transition=CFunction.Transition.NO_TRANSITION)
    public static native DIR fdopendir_no_transition(int var0);

    @CFunction
    public static native DIR fdopendir(int var0);

    @CFunction
    public static native int closedir(DIR var0);

    @CFunction(value="closedir", transition=CFunction.Transition.NO_TRANSITION)
    public static native int closedir_no_transition(DIR var0);

    @CFunction
    public static native dirent readdir(DIR var0);

    @CFunction
    public static native int readdir_r(DIR var0, dirent var1, direntPointer var2);

    @CFunction(value="readdir_r", transition=CFunction.Transition.NO_TRANSITION)
    public static native int readdir_r_no_transition(DIR var0, dirent var1, direntPointer var2);

    @CFunction
    public static native void rewinddir(DIR var0);

    @CFunction
    public static native void seekdir(DIR var0, long var1);

    @CFunction
    public static native long telldir(DIR var0);

    @CFunction
    public static native int dirfd(DIR var0);

    @CConstant
    public static native int MAXNAMLEN();

    @CFunction
    public static native int scandir(CCharPointer var0, PointerBase var1, CFunctionPointer var2, CFunctionPointer var3);

    @CFunction
    public static native int scandirat(int var0, CCharPointer var1, PointerBase var2, CFunctionPointer var3, CFunctionPointer var4);

    @CFunction
    public static native int alphasort(direntPointer var0, direntPointer var1);

    @CFunction
    public static native SignedWord getdirentries(int var0, CCharPointer var1, SignedWord var2, PointerBase var3);

    @CFunction
    public static native int versionsort(direntPointer var0, direntPointer var1);

    public static interface DIR
    extends PointerBase {
    }

    @CPointerTo(value=dirent.class)
    public static interface direntPointer
    extends PointerBase {
        public dirent read();

        public void write(dirent var1);
    }

    @CStruct(addStructKeyword=true)
    public static interface dirent
    extends PointerBase {
        @CField
        public long d_ino();

        @CField
        @Platforms(value={Platform.LINUX.class})
        public long d_off();

        @CField
        public short d_reclen();

        @CField
        public byte d_type();

        @CFieldAddress
        public CCharPointer d_name();
    }
}

