/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jni.functions;

import com.oracle.svm.core.annotate.UnknownObjectField;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.jni.functions.JNIStructFunctionsInitializer;
import com.oracle.svm.jni.nativeapi.JNIInvokeInterface;
import com.oracle.svm.jni.nativeapi.JNIJavaVM;
import com.oracle.svm.jni.nativeapi.JNINativeInterface;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

public final class JNIFunctionTables {
    @UnknownObjectField(types={JNIStructFunctionsInitializer.class})
    private JNIStructFunctionsInitializer<JNIInvokeInterface> invokesInitializer;
    private JNIJavaVM globalJavaVM;
    @UnknownObjectField(types={JNIStructFunctionsInitializer.class})
    private JNIStructFunctionsInitializer<JNINativeInterface> functionTableInitializer;
    private final UninterruptibleUtils.AtomicPointer<JNINativeInterface> globalFunctionTable = new UninterruptibleUtils.AtomicPointer();

    static void create() {
        ImageSingletons.add(JNIFunctionTables.class, (Object)new JNIFunctionTables());
    }

    public static JNIFunctionTables singleton() {
        return (JNIFunctionTables)ImageSingletons.lookup(JNIFunctionTables.class);
    }

    private JNIFunctionTables() {
    }

    void initialize(JNIStructFunctionsInitializer<JNIInvokeInterface> invokes, JNIStructFunctionsInitializer<JNINativeInterface> functionTable) {
        assert (this.invokesInitializer == null && this.functionTableInitializer == null);
        this.invokesInitializer = invokes;
        this.functionTableInitializer = functionTable;
    }

    public JNIJavaVM getGlobalJavaVM() {
        if (this.globalJavaVM.isNull()) {
            JNIInvokeInterface invokes = (JNIInvokeInterface)UnmanagedMemory.calloc((int)SizeOf.get(JNIInvokeInterface.class));
            this.invokesInitializer.initialize(invokes);
            invokes.setIsolate(CurrentIsolate.getIsolate());
            this.globalJavaVM = (JNIJavaVM)UnmanagedMemory.calloc((int)SizeOf.get(JNIJavaVM.class));
            this.globalJavaVM.setFunctions(invokes);
            RuntimeSupport.getRuntimeSupport().addTearDownHook(() -> {
                UnmanagedMemory.free((PointerBase)this.globalJavaVM.getFunctions());
                UnmanagedMemory.free((PointerBase)this.globalJavaVM);
                this.globalJavaVM = (JNIJavaVM)WordFactory.nullPointer();
            });
        }
        return this.globalJavaVM;
    }

    public JNINativeInterface getGlobalFunctionTable() {
        JNINativeInterface functionTable = this.globalFunctionTable.get();
        if (functionTable.isNull()) {
            functionTable = (JNINativeInterface)UnmanagedMemory.malloc((int)SizeOf.get(JNINativeInterface.class));
            this.functionTableInitializer.initialize(functionTable);
            if (this.globalFunctionTable.compareAndSet((JNINativeInterface)WordFactory.nullPointer(), functionTable)) {
                RuntimeSupport.getRuntimeSupport().addTearDownHook(() -> UnmanagedMemory.free((PointerBase)this.globalFunctionTable.get()));
            } else {
                UnmanagedMemory.free((PointerBase)functionTable);
                functionTable = this.globalFunctionTable.get();
            }
        }
        return functionTable;
    }
}

