/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.runtime;

import com.oracle.tools.Option;
import com.oracle.tools.options.Timeout;
import com.oracle.tools.runtime.Application;
import com.oracle.tools.runtime.ApplicationConsole;
import com.oracle.tools.runtime.ApplicationProcess;
import com.oracle.tools.runtime.ApplicationRuntime;
import com.oracle.tools.runtime.FluentApplication;
import com.oracle.tools.runtime.LifecycleEvent;
import com.oracle.tools.runtime.LifecycleEventInterceptor;
import com.oracle.tools.runtime.Platform;
import com.oracle.tools.runtime.java.container.Container;
import com.oracle.tools.runtime.options.Diagnostics;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public abstract class AbstractApplication<A extends AbstractApplication<A, P, R>, P extends ApplicationProcess, R extends ApplicationRuntime<P>>
implements FluentApplication<A> {
    protected final R runtime;
    private final Thread stdoutThread;
    private final Thread stderrThread;
    private final Thread stdinThread;
    private List<LifecycleEventInterceptor<? super A>> interceptors;
    private Timeout defaultTimeout;

    public AbstractApplication(R runtime, Iterable<LifecycleEventInterceptor<? super A>> interceptors) {
        this.runtime = runtime;
        this.defaultTimeout = (Timeout)runtime.getOptions().get(Timeout.class, (Option)Timeout.autoDetect());
        this.interceptors = new ArrayList<LifecycleEventInterceptor<? super A>>();
        if (interceptors != null) {
            for (LifecycleEventInterceptor<A> lifecycleEventInterceptor : interceptors) {
                this.interceptors.add(lifecycleEventInterceptor);
            }
        }
        String displayName = runtime.getApplicationName();
        Object p = runtime.getApplicationProcess();
        ApplicationConsole console = runtime.getApplicationConsole();
        boolean diagnosticsEnabled = ((Diagnostics)runtime.getOptions().get(Diagnostics.class, (Option)Diagnostics.autoDetect())).isEnabled();
        this.stdoutThread = new Thread(new OutputRedirector(displayName, "out", p.getInputStream(), console.getOutputWriter(), p.getId(), diagnosticsEnabled, console.isDiagnosticsEnabled()));
        this.stdoutThread.setDaemon(true);
        this.stdoutThread.setName(displayName + " StdOut Thread");
        this.stdoutThread.start();
        this.stderrThread = new Thread(new OutputRedirector(displayName, "err", p.getErrorStream(), console.getErrorWriter(), p.getId(), diagnosticsEnabled, console.isDiagnosticsEnabled()));
        this.stderrThread.setDaemon(true);
        this.stderrThread.setName(displayName + " StdErr Thread");
        this.stderrThread.start();
        this.stdinThread = new Thread(new InputRedirector(console.getInputReader(), p.getOutputStream()));
        this.stdinThread.setDaemon(true);
        this.stdinThread.setName(displayName + " StdIn Thread");
        this.stdinThread.start();
    }

    @Override
    public Timeout getDefaultTimeout() {
        return this.defaultTimeout;
    }

    @Override
    public Properties getEnvironmentVariables() {
        return this.runtime.getEnvironmentVariables();
    }

    @Override
    public String getName() {
        return this.runtime.getApplicationName();
    }

    @Override
    public Platform getPlatform() {
        return this.runtime.getPlatform();
    }

    @Override
    public void close() {
        this.runtime.getApplicationProcess().close();
        try {
            this.stdinThread.interrupt();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.stdoutThread.interrupt();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.stdoutThread.join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        try {
            this.stderrThread.interrupt();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.stderrThread.join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        try {
            this.runtime.getApplicationConsole().close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.runtime.getApplicationProcess().waitFor();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        LifecycleEvent<Application> event = new LifecycleEvent<Application>(){

            @Override
            public Enum<?> getType() {
                return Application.EventKind.DESTROYED;
            }

            @Override
            public Application getObject() {
                return AbstractApplication.this;
            }
        };
        for (LifecycleEventInterceptor<A> interceptor : this.getLifecycleInterceptors()) {
            interceptor.onEvent(event);
        }
    }

    @Override
    public long getId() {
        return this.runtime.getApplicationProcess().getId();
    }

    @Override
    public Iterable<LifecycleEventInterceptor<? super A>> getLifecycleInterceptors() {
        return this.interceptors;
    }

    @Override
    public int waitFor() {
        return this.runtime.getApplicationProcess().waitFor();
    }

    @Override
    public int exitValue() {
        return this.runtime.getApplicationProcess().exitValue();
    }

    static class OutputRedirector
    implements Runnable {
        private String applicationName;
        private String prefix;
        private long processId;
        private boolean diagnosticsEnabled;
        private InputStream inputStream;
        private PrintWriter printWriter;
        private boolean consoleDiagnosticsEnabled;

        OutputRedirector(String applicationName, String prefix, InputStream inputStream, PrintWriter printWriter, long processId, boolean diagnosticsEnabled, boolean consoleDiagnosticsEnabled) {
            this.applicationName = applicationName;
            this.prefix = prefix;
            this.inputStream = inputStream;
            this.printWriter = printWriter;
            this.processId = processId;
            this.diagnosticsEnabled = diagnosticsEnabled;
            this.consoleDiagnosticsEnabled = consoleDiagnosticsEnabled;
        }

        @Override
        public void run() {
            long lineNumber = 1L;
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(new BufferedInputStream(this.inputStream)));
                boolean running = true;
                while (running || reader.ready()) {
                    try {
                        String line = reader.readLine();
                        if (line != null) {
                            String output;
                            String diagnosticOutput = this.diagnosticsEnabled || this.consoleDiagnosticsEnabled ? String.format("[%s:%s%s] %4d: %s", this.applicationName, this.prefix, this.processId < 0L ? "" : ":" + this.processId, lineNumber++, line) : null;
                            String string = output = this.consoleDiagnosticsEnabled ? diagnosticOutput : line;
                            if (this.diagnosticsEnabled) {
                                Container.getPlatformScope().getStandardOutput().println(output);
                            }
                            this.printWriter.println(output);
                            this.printWriter.flush();
                        }
                        break;
                    }
                    catch (InterruptedIOException e) {
                        running = false;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                String output;
                String diagnosticOutput = this.diagnosticsEnabled || this.consoleDiagnosticsEnabled ? String.format("[%s:%s%s] %4d: (terminated)", this.applicationName, this.prefix, this.processId < 0L ? "" : ":" + this.processId, lineNumber) : null;
                String string = output = this.consoleDiagnosticsEnabled ? diagnosticOutput : "(terminated)";
                if (this.diagnosticsEnabled) {
                    Container.getPlatformScope().getStandardOutput().println(output);
                }
                this.printWriter.println(output);
                this.printWriter.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class InputRedirector
    implements Runnable {
        private Reader reader;
        private OutputStream outputStream;

        private InputRedirector(Reader reader, OutputStream outputStream) {
            this.reader = reader;
            this.outputStream = outputStream;
        }

        @Override
        public void run() {
            try {
                String line;
                BufferedReader bufferedReader = new BufferedReader(this.reader);
                PrintWriter printWriter = new PrintWriter(this.outputStream);
                while ((line = bufferedReader.readLine()) != null) {
                    printWriter.println(line);
                    printWriter.flush();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

