/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.runtime;

import com.oracle.tools.Option;
import com.oracle.tools.Options;
import com.oracle.tools.options.Timeout;
import com.oracle.tools.runtime.Application;
import com.oracle.tools.runtime.ApplicationSchema;
import com.oracle.tools.runtime.FluentApplicationSchema;
import com.oracle.tools.runtime.LifecycleEventInterceptor;
import com.oracle.tools.runtime.Platform;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractApplicationSchema<A extends Application, S extends AbstractApplicationSchema<A, S>>
implements FluentApplicationSchema<A, S> {
    private String executableName;
    private File workingDirectory;
    private ArrayList<String> applicationArguments;
    private LinkedList<LifecycleEventInterceptor<? super A>> lifecycleInterceptors;
    private Options options;

    public AbstractApplicationSchema(ApplicationSchema<A> schema) {
        this.executableName = schema.getExecutableName();
        this.workingDirectory = schema.getWorkingDirectory();
        this.applicationArguments = new ArrayList<String>(schema.getArguments());
        this.lifecycleInterceptors = new LinkedList();
        this.options = new Options(schema.getOptions().asArray());
        for (LifecycleEventInterceptor<A> interceptor : schema.getLifecycleInterceptors()) {
            this.lifecycleInterceptors.add(interceptor);
        }
    }

    public AbstractApplicationSchema(String executableName) {
        this.executableName = executableName;
        this.applicationArguments = new ArrayList();
        this.lifecycleInterceptors = new LinkedList();
        this.options = new Options(new Option[0]);
        this.options.add((Option)Timeout.autoDetect());
    }

    @Override
    public String getExecutableName() {
        return this.executableName;
    }

    @Override
    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public S setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
        return (S)this;
    }

    @Override
    public S addArgument(String argument) {
        this.applicationArguments.add(argument);
        return (S)this;
    }

    @Override
    public S addArguments(String ... arguments) {
        if (arguments != null) {
            for (String argument : arguments) {
                this.applicationArguments.add(argument);
            }
        }
        return (S)this;
    }

    @Override
    public S addArguments(List<String> arguments) {
        if (arguments != null) {
            for (String argument : arguments) {
                this.applicationArguments.add(argument);
            }
        }
        return (S)this;
    }

    @Override
    public S setArguments(String ... arguments) {
        this.applicationArguments.clear();
        return (S)this.addArguments(arguments);
    }

    @Override
    public S setArguments(List<String> arguments) {
        this.applicationArguments.clear();
        return (S)this.addArguments((List)arguments);
    }

    @Override
    public List<String> getArguments() {
        return this.applicationArguments;
    }

    @Deprecated
    public S setArgument(String argument) {
        this.addArgument(argument);
        return (S)this;
    }

    @Override
    public Iterable<LifecycleEventInterceptor<? super A>> getLifecycleInterceptors() {
        return this.lifecycleInterceptors;
    }

    @Override
    public S addLifecycleInterceptor(LifecycleEventInterceptor<? super A> interceptor) {
        this.lifecycleInterceptors.add(interceptor);
        return (S)this;
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    @Override
    public S addOption(Option option) {
        this.options.add(option);
        return (S)this;
    }

    @Override
    public S addOptions(Option ... options) {
        if (options != null) {
            for (Option option : options) {
                this.options.add(option);
            }
        }
        return (S)this;
    }

    @Override
    public S addOptionIfAbsent(Option option) {
        this.options.addIfAbsent(option);
        return (S)this;
    }

    @Override
    public S setOptions(Option ... options) {
        this.options = new Options(options);
        return (S)this;
    }

    @Override
    public Options getPlatformSpecificOptions(Platform platform) {
        return new Options(this.options.asArray());
    }
}

