/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.runtime;

import com.oracle.tools.predicate.Predicate;
import com.oracle.tools.runtime.Application;
import com.oracle.tools.runtime.Assembly;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractAssembly<A extends Application>
implements Assembly<A> {
    protected CopyOnWriteArraySet<A> applications;
    protected AtomicBoolean isClosed;

    public AbstractAssembly(List<? extends A> applications) {
        this.applications = new CopyOnWriteArraySet<A>(applications);
        this.isClosed = new AtomicBoolean(false);
    }

    public boolean isClosed() {
        return this.isClosed.get();
    }

    public A get(String name) {
        for (Application application : this.applications) {
            if (!application.getName().equals(name)) continue;
            return (A)application;
        }
        return null;
    }

    public Iterable<A> getAll(String prefix) {
        LinkedList<Application> list = new LinkedList<Application>();
        for (Application application : this.applications) {
            if (!application.getName().startsWith(prefix)) continue;
            list.add(application);
        }
        return list;
    }

    public Iterable<A> getAll(Predicate<? super A> predicate) {
        LinkedList<Application> list = new LinkedList<Application>();
        for (Application application : this.applications) {
            if (!predicate.evaluate((Object)application)) continue;
            list.add(application);
        }
        return list;
    }

    public void add(A application) {
        if (this.isClosed()) {
            throw new IllegalStateException("Can't add [" + application + "] as the " + this.getClass().getName() + " is closed");
        }
        this.applications.add(application);
    }

    public boolean remove(A application) {
        if (this.isClosed()) {
            throw new IllegalStateException("Can't add [" + application + "] as the " + this.getClass().getName() + " is closed");
        }
        return this.applications.remove(application);
    }

    @Override
    public Iterator<A> iterator() {
        return this.applications.iterator();
    }

    @Override
    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            for (Application application : this.applications) {
                if (application == null) continue;
                try {
                    application.close();
                }
                catch (Exception exception) {}
            }
            this.applications.clear();
        }
    }

    @Override
    public int size() {
        return this.applications.size();
    }

    @Deprecated
    public void destroy() {
        this.close();
    }
}

