/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.runtime;

import com.oracle.tools.Option;
import com.oracle.tools.runtime.Application;
import com.oracle.tools.runtime.ApplicationConsole;
import com.oracle.tools.runtime.ApplicationConsoleBuilder;
import com.oracle.tools.runtime.ApplicationSchema;
import com.oracle.tools.runtime.Assembly;
import com.oracle.tools.runtime.AssemblyBuilder;
import com.oracle.tools.runtime.Platform;
import com.oracle.tools.runtime.console.NullApplicationConsole;
import com.oracle.tools.runtime.console.SingletonApplicationConsoleBuilder;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractAssemblyBuilder<A extends Application, G extends Assembly<A>>
implements AssemblyBuilder<A, G> {
    protected LinkedHashMap<String, Characteristics<A>> characteristics = new LinkedHashMap();

    @Override
    public <T extends A, S extends ApplicationSchema<T>> void addSchema(String applicationNamePrefix, S applicationSchema, int count, Platform platform, Option ... options) {
        this.addSchema(applicationNamePrefix, applicationSchema, count, null, platform, options);
    }

    @Override
    public <T extends A, S extends ApplicationSchema<T>> void addSchema(String applicationNamePrefix, S applicationSchema, int count, ApplicationConsoleBuilder consoleBuilder, Platform platform, Option ... options) {
        this.characteristics.put(applicationNamePrefix, new Characteristics(applicationSchema, count, consoleBuilder, platform, options));
    }

    @Override
    public G realize(ApplicationConsoleBuilder overridingConsoleBuilder) {
        LinkedList applications = new LinkedList();
        this.realizeApplicationFromSchema(applications, overridingConsoleBuilder);
        return this.createAssembly(applications);
    }

    @Override
    public G realize(ApplicationConsole overridingConsole) {
        return this.realize(overridingConsole == null ? null : new SingletonApplicationConsoleBuilder(overridingConsole));
    }

    @Override
    public G realize() throws IOException {
        return this.realize((ApplicationConsoleBuilder)null);
    }

    protected void realizeApplicationFromSchema(LinkedList<A> applications, ApplicationConsoleBuilder overridingConsoleBuilder) {
        for (String prefix : this.characteristics.keySet()) {
            Characteristics<A> characteristic = this.characteristics.get(prefix);
            ApplicationSchema<A> schema = characteristic.getApplicationSchema();
            int instanceCount = characteristic.getInstanceCount();
            ApplicationConsoleBuilder consoleBuilder = characteristic.getConsoleBuilder();
            Platform platform = characteristic.getPlatform();
            Option[] options = characteristic.getOptions();
            if (overridingConsoleBuilder != null) {
                consoleBuilder = overridingConsoleBuilder;
            }
            for (int i = 1; i <= instanceCount; ++i) {
                ApplicationConsole console;
                String applicationName = String.format("%s-%d", prefix, i);
                ApplicationConsole applicationConsole = console = consoleBuilder == null ? null : consoleBuilder.realize(applicationName);
                if (console == null) {
                    console = new NullApplicationConsole();
                }
                applications.add(platform.realize(applicationName, schema, console, options));
            }
        }
    }

    protected abstract G createAssembly(List<? extends A> var1);

    protected static class Characteristics<A extends Application> {
        private ApplicationSchema<A> schema;
        private int count;
        private ApplicationConsoleBuilder consoleBuilder;
        private Platform platform;
        private Option[] options;

        public Characteristics(ApplicationSchema<A> schema, int count, ApplicationConsoleBuilder consoleBuilder, Platform platform, Option ... options) {
            this.schema = schema;
            this.count = count;
            this.consoleBuilder = consoleBuilder;
            this.platform = platform;
            this.options = options;
        }

        public ApplicationSchema<A> getApplicationSchema() {
            return this.schema;
        }

        public int getInstanceCount() {
            return this.count;
        }

        public ApplicationConsoleBuilder getConsoleBuilder() {
            return this.consoleBuilder;
        }

        public Platform getPlatform() {
            return this.platform;
        }

        public Option[] getOptions() {
            return this.options;
        }
    }
}

