/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.runtime;

import com.oracle.tools.runtime.Platform;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Infrastructure<P extends Platform>
implements Iterable<P>,
Closeable {
    private final Map<String, P> platforms = new HashMap<String, P>();

    public Infrastructure() {
        this(null);
    }

    public Infrastructure(Map<String, P> platforms) {
        if (platforms != null) {
            this.platforms.putAll(platforms);
        }
    }

    public int size() {
        return this.platforms.size();
    }

    public <T extends P> T getPlatform(String name) {
        return (T)((Platform)this.platforms.get(name));
    }

    public void addPlatform(P platform) {
        String name = platform.getName();
        if (this.platforms.containsKey(name)) {
            throw new IllegalArgumentException("This infrastructure already contains a platform with the name " + name);
        }
        this.platforms.put(name, platform);
    }

    @Override
    public Iterator<P> iterator() {
        return Collections.unmodifiableCollection(this.platforms.values()).iterator();
    }

    public void closePlatform(String name) {
        Platform platform = (Platform)this.platforms.remove(name);
        if (platform instanceof Closeable) {
            try {
                ((Closeable)((Object)platform)).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void close() throws IOException {
        for (Platform platform : this.platforms.values()) {
            if (!(platform instanceof Closeable)) continue;
            try {
                ((Closeable)((Object)platform)).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.platforms.clear();
    }
}

