/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.runtime;

import com.oracle.tools.Option;
import com.oracle.tools.predicate.Predicate;
import com.oracle.tools.runtime.Application;
import com.oracle.tools.runtime.ApplicationConsole;
import com.oracle.tools.runtime.ApplicationConsoleBuilder;
import com.oracle.tools.runtime.ApplicationSchema;
import com.oracle.tools.runtime.Assembly;
import com.oracle.tools.runtime.Infrastructure;
import com.oracle.tools.runtime.Platform;
import com.oracle.tools.runtime.SimpleAssembly;
import com.oracle.tools.runtime.console.NullApplicationConsole;
import com.oracle.tools.runtime.console.SingletonApplicationConsoleBuilder;
import com.oracle.tools.util.Quadruple;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;

public class InfrastructureAssemblyBuilder<P extends Platform, A extends Application, G extends Assembly<A>> {
    private Map<String, Quadruple<Predicate<P>, ApplicationSchema<A>, Integer, ApplicationConsoleBuilder>> apps = new LinkedHashMap<String, Quadruple<Predicate<P>, ApplicationSchema<A>, Integer, ApplicationConsoleBuilder>>();

    public <T extends A, S extends ApplicationSchema<T>> void addApplication(String applicationNamePrefix, S applicationSchema, int instancesPerPlatform) {
        this.addApplication(null, applicationNamePrefix, applicationSchema, instancesPerPlatform, (ApplicationConsoleBuilder)null);
    }

    public <T extends A, S extends ApplicationSchema<T>> void addApplication(Predicate<P> predicate, String applicationNamePrefix, S applicationSchema, int instancesPerPlatform) {
        this.addApplication(predicate, applicationNamePrefix, applicationSchema, instancesPerPlatform, (ApplicationConsoleBuilder)null);
    }

    public <T extends A, S extends ApplicationSchema<T>> void addApplication(String applicationNamePrefix, S applicationSchema, int instancesPerPlatform, ApplicationConsoleBuilder consoleBuilder) {
        this.apps.put(applicationNamePrefix, new Quadruple(null, applicationSchema, (Object)instancesPerPlatform, (Object)consoleBuilder));
    }

    public <T extends A, S extends ApplicationSchema<T>> void addApplication(Predicate<P> predicate, String applicationNamePrefix, S applicationSchema, int instancesPerPlatform, ApplicationConsole console) {
        this.apps.put(applicationNamePrefix, new Quadruple(predicate, applicationSchema, (Object)instancesPerPlatform, (Object)new SingletonApplicationConsoleBuilder(console)));
    }

    public <T extends A, S extends ApplicationSchema<T>> void addApplication(Predicate<P> predicate, String applicationNamePrefix, S applicationSchema, int instancesPerPlatform, ApplicationConsoleBuilder consoleBuilder) {
        this.apps.put(applicationNamePrefix, new Quadruple(predicate, applicationSchema, (Object)instancesPerPlatform, (Object)consoleBuilder));
    }

    public G realize(Infrastructure<P> infrastructure, ApplicationConsoleBuilder overridingConsoleBuilder) {
        LinkedList applications = new LinkedList();
        for (Map.Entry<String, Quadruple<Predicate<P>, ApplicationSchema<A>, Integer, ApplicationConsoleBuilder>> entry : this.apps.entrySet()) {
            Quadruple<Predicate<P>, ApplicationSchema<A>, Integer, ApplicationConsoleBuilder> quad = entry.getValue();
            String prefix = entry.getKey();
            Predicate predicate = (Predicate)quad.getA();
            ApplicationSchema schema = (ApplicationSchema)quad.getB();
            int count = (Integer)quad.getC();
            ApplicationConsoleBuilder consoleBuilder = (ApplicationConsoleBuilder)quad.getD();
            if (overridingConsoleBuilder != null) {
                consoleBuilder = overridingConsoleBuilder;
            }
            for (Platform platform : infrastructure) {
                if (predicate != null && !predicate.evaluate((Object)platform)) continue;
                for (int i = 1; i <= count; ++i) {
                    ApplicationConsole console;
                    String name = String.format("%s-%d@%s", prefix, i, platform.getName());
                    ApplicationConsole applicationConsole = console = consoleBuilder == null ? null : consoleBuilder.realize(name);
                    if (console == null) {
                        console = new NullApplicationConsole();
                    }
                    Object application = platform.realize(name, schema, console, new Option[0]);
                    applications.add(application);
                }
            }
        }
        return (G)new SimpleAssembly(applications);
    }

    public G realize(Infrastructure<P> infrastructure, ApplicationConsole overridingConsole) {
        return this.realize(infrastructure, overridingConsole == null ? null : new SingletonApplicationConsoleBuilder(overridingConsole));
    }

    public G realize(Infrastructure<P> infrastructure) throws IOException {
        return this.realize(infrastructure, (ApplicationConsoleBuilder)null);
    }
}

