/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.runtime;

import com.oracle.tools.runtime.Infrastructure;
import com.oracle.tools.runtime.Platform;
import com.oracle.tools.runtime.PlatformBuilder;
import com.oracle.tools.runtime.PlatformSchema;
import com.oracle.tools.util.Pair;
import com.oracle.tools.util.Quadruple;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class InfrastructureBuilder<P extends Platform> {
    private final List<Quadruple<PlatformBuilder<P>, PlatformSchema<P>, String, Integer>> schema;
    private final List<P> platforms;
    private ExecutorService executor;

    public InfrastructureBuilder() {
        this(null);
    }

    public InfrastructureBuilder(ExecutorService executor) {
        this.executor = executor != null ? executor : Executors.newFixedThreadPool(5);
        this.schema = new LinkedList<Quadruple<PlatformBuilder<P>, PlatformSchema<P>, String, Integer>>();
        this.platforms = new LinkedList<P>();
    }

    public <T extends P> InfrastructureBuilder<P> addPlatform(T platform) {
        if (platform != null) {
            this.platforms.add(platform);
        }
        return this;
    }

    public <T extends P, B extends PlatformBuilder<T>, S extends PlatformSchema<T>> InfrastructureBuilder<P> addPlatform(B builder, S platformSchema) {
        return this.addPlatform(builder, platformSchema, platformSchema.getName(), 1);
    }

    public <T extends P, B extends PlatformBuilder<T>, S extends PlatformSchema<T>> InfrastructureBuilder<P> addPlatform(B builder, S platformSchema, String name) {
        return this.addPlatform(builder, platformSchema, name, 1);
    }

    public <T extends P, B extends PlatformBuilder<T>, S extends PlatformSchema<T>> InfrastructureBuilder<P> addPlatform(B builder, S platformSchema, int count) {
        return this.addPlatform(builder, platformSchema, platformSchema.getName(), count);
    }

    public <T extends P, B extends PlatformBuilder<T>, S extends PlatformSchema<T>> InfrastructureBuilder<P> addPlatform(B builder, S platformSchema, String name, int count) {
        if (count <= 0) {
            throw new IllegalArgumentException("Count must be greater than zero");
        }
        this.schema.add(new Quadruple(builder, platformSchema, (Object)name, (Object)count));
        return this;
    }

    public Infrastructure<P> realize() {
        try {
            HashMap<Object, Object> platformMap = new HashMap<Object, Object>();
            ArrayList futures = new ArrayList();
            for (Platform platform : this.platforms) {
                platformMap.put(platform.getName(), platform);
            }
            for (Quadruple quadruple : this.schema) {
                PlatformBuilder builder = (PlatformBuilder)quadruple.getA();
                PlatformSchema schema = (PlatformSchema)quadruple.getB();
                String name = (String)quadruple.getC();
                int count = (Integer)quadruple.getD();
                if (count == 1) {
                    Future future = this.executor.submit(new PlatformRealizer(name, builder, schema));
                    futures.add(future);
                    continue;
                }
                for (int i = 1; i <= count; ++i) {
                    String instanceName = name + '-' + i;
                    Future future = this.executor.submit(new PlatformRealizer(instanceName, builder, schema));
                    futures.add(future);
                }
            }
            for (Future future : futures) {
                Pair pair = (Pair)future.get();
                platformMap.put(pair.getX(), pair.getY());
            }
            return new Infrastructure(platformMap);
        }
        catch (Exception e) {
            throw new RuntimeException("Error realizing platforms", e);
        }
    }

    private class PlatformRealizer
    implements Callable<Pair<String, P>> {
        private String name;
        private PlatformBuilder<P> builder;
        private PlatformSchema<P> schema;

        private PlatformRealizer(String name, PlatformBuilder<P> builder, PlatformSchema<P> schema) {
            this.name = name;
            this.builder = builder;
            this.schema = schema;
        }

        @Override
        public Pair<String, P> call() throws Exception {
            Object platform = this.builder.realize(this.name, this.schema);
            return new Pair((Object)this.name, platform);
        }
    }
}

