/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.runtime;

import com.oracle.tools.runtime.ApplicationProcess;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Field;

public class LocalApplicationProcess
implements ApplicationProcess {
    protected Process process;

    public LocalApplicationProcess(Process process) {
        if (process == null) {
            throw new NullPointerException("The provided process can't be null");
        }
        this.process = process;
    }

    @Override
    @Deprecated
    public void destroy() {
        this.close();
    }

    @Override
    public void close() {
        this.process.destroy();
    }

    @Override
    public long getId() {
        long id = -1L;
        try {
            if (this.process.getClass().getSimpleName().equals("UNIXProcess")) {
                Class<?> clazz = this.process.getClass();
                Field field = clazz.getDeclaredField("pid");
                field.setAccessible(true);
                Object oPid = field.get(this.process);
                if (oPid instanceof Number) {
                    id = ((Number)oPid).longValue();
                } else if (oPid instanceof String) {
                    id = Long.parseLong((String)oPid);
                }
            } else {
                RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
                String sProcess = runtimeMXBean.getName();
                int iPID = sProcess.indexOf(64);
                if (iPID > 0) {
                    String sPID = sProcess.substring(0, iPID);
                    id = Long.parseLong(sPID);
                }
            }
        }
        catch (SecurityException e) {
        }
        catch (NoSuchFieldException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return id;
    }

    @Override
    public int exitValue() {
        return this.process.exitValue();
    }

    @Override
    public InputStream getErrorStream() {
        return this.process.getErrorStream();
    }

    @Override
    public InputStream getInputStream() {
        return this.process.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() {
        return this.process.getOutputStream();
    }

    @Override
    public int waitFor() {
        try {
            return this.process.waitFor();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while waiting for application to terminate", e);
        }
    }
}

