/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.runtime;

import com.oracle.tools.runtime.AbstractPlatform;
import com.oracle.tools.runtime.Application;
import com.oracle.tools.runtime.ApplicationBuilder;
import com.oracle.tools.runtime.SimpleApplicationBuilder;
import com.oracle.tools.runtime.java.JavaApplication;
import com.oracle.tools.runtime.java.LocalJavaApplicationBuilder;
import com.oracle.tools.runtime.network.AvailablePortIterator;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class LocalPlatform
extends AbstractPlatform {
    private static LocalPlatform INSTANCE = new LocalPlatform();
    private AvailablePortIterator availablePortIterator = new AvailablePortIterator(this.getPrivateInetAddress(), 30000, 65535);

    private LocalPlatform() {
        super("Local");
    }

    @Override
    public InetAddress getPublicInetAddress() {
        try {
            return InetAddress.getByName(this.getHostName());
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Unable to obtain an InetAddress for the LocalPlatform", e);
        }
    }

    public String getHostName() {
        if (System.getProperties().containsKey("tangosol.coherence.localhost")) {
            return System.getProperty("tangosol.coherence.localhost");
        }
        return "127.0.0.1";
    }

    public AvailablePortIterator getAvailablePorts() {
        return this.availablePortIterator;
    }

    @Override
    public <A extends Application, B extends ApplicationBuilder<A>> B getApplicationBuilder(Class<A> applicationClass) {
        if (JavaApplication.class.isAssignableFrom(applicationClass)) {
            return (B)new LocalJavaApplicationBuilder();
        }
        return (B)new SimpleApplicationBuilder();
    }

    public static LocalPlatform getInstance() {
        return INSTANCE;
    }
}

