/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.runtime;

import com.oracle.tools.Option;
import com.oracle.tools.Options;
import com.oracle.tools.runtime.AbstractApplicationBuilder;
import com.oracle.tools.runtime.Application;
import com.oracle.tools.runtime.ApplicationConsole;
import com.oracle.tools.runtime.ApplicationSchema;
import com.oracle.tools.runtime.FluentApplicationSchema;
import com.oracle.tools.runtime.LocalApplicationProcess;
import com.oracle.tools.runtime.Platform;
import com.oracle.tools.runtime.SimpleApplication;
import com.oracle.tools.runtime.SimpleApplicationRuntime;
import com.oracle.tools.runtime.options.EnvironmentVariables;
import com.oracle.tools.runtime.options.ErrorStreamRedirection;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;

public class SimpleApplicationBuilder
extends AbstractApplicationBuilder<SimpleApplication> {
    @Override
    public <T extends SimpleApplication, S extends ApplicationSchema<T>> T realize(S applicationSchema, String applicationName, ApplicationConsole console, Platform platform, Option ... applicationOptions) {
        Process process;
        Options options = applicationSchema.getPlatformSpecificOptions(platform);
        options.addAll(applicationOptions);
        S schema = applicationSchema;
        ProcessBuilder processBuilder = new ProcessBuilder(schema.getExecutableName());
        File directory = schema.getWorkingDirectory();
        if (directory != null) {
            processBuilder.directory(directory);
        }
        EnvironmentVariables environmentVariables = (EnvironmentVariables)options.get(EnvironmentVariables.class, (Option)EnvironmentVariables.inherited());
        switch (environmentVariables.getSource()) {
            case Custom: {
                processBuilder.environment().clear();
                break;
            }
            case ThisApplication: {
                processBuilder.environment().clear();
                processBuilder.environment().putAll(System.getenv());
                break;
            }
        }
        Properties variables = environmentVariables.getBuilder().realize();
        for (String variableName : variables.stringPropertyNames()) {
            processBuilder.environment().put(variableName, variables.getProperty(variableName));
        }
        List<String> command = processBuilder.command();
        for (String argument : schema.getArguments()) {
            command.add(argument);
        }
        ErrorStreamRedirection redirection = (ErrorStreamRedirection)options.get(ErrorStreamRedirection.class, (Option)ErrorStreamRedirection.disabled());
        processBuilder.redirectErrorStream(redirection.isEnabled());
        try {
            process = processBuilder.start();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to build the underlying native process for the application", e);
        }
        SimpleApplicationRuntime environment = new SimpleApplicationRuntime(applicationName, platform, options, new LocalApplicationProcess(process), console, variables);
        SimpleApplication application = new SimpleApplication(environment, schema instanceof FluentApplicationSchema ? ((FluentApplicationSchema)schema).getLifecycleInterceptors() : null);
        this.raiseApplicationLifecycleEvent(application, Application.EventKind.REALIZED);
        return (T)application;
    }
}

