/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.runtime.actions;

import com.oracle.tools.runtime.Application;
import com.oracle.tools.runtime.Assembly;
import com.oracle.tools.runtime.actions.Action;
import com.oracle.tools.runtime.actions.ActionExecutor;
import com.oracle.tools.runtime.actions.ConditionalAction;
import com.oracle.tools.runtime.actions.CustomAction;
import com.oracle.tools.runtime.actions.Sequence;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Stack;

public class InteractiveActionExecutor<A extends Application, G extends Assembly<A>>
implements ActionExecutor<A, G> {
    private G assembly;
    private Action<A, G> initialAction;
    private Stack<Iterator<Action<A, G>>> actionsStack;

    public InteractiveActionExecutor(G assembly, Action<A, G> action) {
        this.assembly = assembly;
        this.initialAction = action;
        this.restart();
    }

    public void restart() {
        this.actionsStack = new Stack();
        if (this.initialAction != null) {
            this.actionsStack.push(Collections.singletonList(this.initialAction).iterator());
        }
    }

    public boolean executeNext() {
        boolean hasExecutedAnAction = false;
        while (!this.actionsStack.isEmpty() && !hasExecutedAnAction) {
            Sequence sequence;
            Iterator<Action<A, G>> actions = this.actionsStack.pop();
            Action<A, G> action = actions.next();
            if (actions.hasNext()) {
                this.actionsStack.push(actions);
            }
            if ((!(action instanceof ConditionalAction) || !((ConditionalAction)action).getPredicate().evaluate(this.assembly)) && action instanceof ConditionalAction) continue;
            if (action instanceof CustomAction) {
                CustomAction customAction = (CustomAction)action;
                customAction.perform(this.assembly);
                hasExecutedAnAction = true;
                continue;
            }
            if (!(action instanceof Sequence) || (actions = (sequence = (Sequence)action).getActions()) == null || !actions.hasNext()) continue;
            this.actionsStack.push(actions);
        }
        return !this.actionsStack.isEmpty();
    }

    public void executeAll() {
        while (this.executeNext()) {
        }
    }

    @Override
    public G getAssembly() {
        return this.assembly;
    }

    @Override
    public void close() throws IOException {
        this.actionsStack.clear();
    }
}

