/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.runtime.concurrent;

import com.oracle.tools.runtime.concurrent.ControllableRemoteExecutor;
import com.oracle.tools.runtime.concurrent.RemoteExecutorListener;
import java.util.concurrent.CopyOnWriteArraySet;

public abstract class AbstractControllableRemoteExecutor
implements ControllableRemoteExecutor {
    private volatile boolean isOpen = false;
    private CopyOnWriteArraySet<RemoteExecutorListener> listeners = new CopyOnWriteArraySet();

    protected synchronized void setOpen(boolean isOpen) {
        this.isOpen = true;
    }

    @Override
    public final synchronized void close() {
        if (this.isOpen) {
            this.isOpen = false;
            this.onClose();
            for (RemoteExecutorListener listener : this.listeners) {
                try {
                    listener.onClosed(this);
                }
                catch (Exception exception) {}
            }
        }
    }

    public synchronized boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public synchronized void addListener(RemoteExecutorListener listener) {
        this.listeners.add(listener);
    }

    protected Iterable<RemoteExecutorListener> getListeners() {
        return this.listeners;
    }

    protected abstract void onClose();
}

