/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.runtime.concurrent.callable;

import com.oracle.tools.runtime.concurrent.RemoteCallable;
import com.oracle.tools.util.ReflectionHelper;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;

public class RemoteCallableStaticMethod<T>
implements RemoteCallable<T> {
    private static final long serialVersionUID = 201407070813L;
    private final String className;
    private final String methodName;
    private Object[] args;

    public RemoteCallableStaticMethod(String className, String methodName, Iterable<String> args) {
        this.className = className;
        this.methodName = methodName;
        ArrayList<String> argumentList = new ArrayList<String>();
        for (String arg : args) {
            argumentList.add(arg);
        }
        String[] argumentArray = new String[argumentList.size()];
        argumentList.toArray(argumentArray);
        this.args = new Object[]{argumentArray};
    }

    public RemoteCallableStaticMethod(String className, String methodName, Object ... args) {
        this.className = className;
        this.methodName = methodName;
        this.args = args;
    }

    @Override
    public T call() throws Exception {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = classLoader.loadClass(this.className);
        Method method = ReflectionHelper.getCompatibleMethod(clazz, (String)this.methodName, (Object[])this.args);
        if (method == null) {
            throw new NoSuchMethodException("The specified method [" + this.className + "." + this.methodName + "] for the arguments " + Arrays.toString(this.args) + " could not be located");
        }
        if (Modifier.isStatic(method.getModifiers())) {
            return (T)(this.args.length > 0 ? method.invoke(null, this.args) : method.invoke(null, new Object[0]));
        }
        throw new IllegalArgumentException("The specified method [" + this.className + "." + this.methodName + "] is not static");
    }

    public String toString() {
        return "RemoteCallableStaticMethod{ClassName='" + this.className + '\'' + ", Method='" + this.methodName + '\'' + ", Arguments=" + Arrays.toString(this.args) + '}';
    }
}

