/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.runtime.concurrent.socket;

import com.oracle.tools.io.NetworkHelper;
import com.oracle.tools.predicate.Predicate;
import com.oracle.tools.predicate.Predicates;
import com.oracle.tools.runtime.concurrent.AbstractControllableRemoteExecutor;
import com.oracle.tools.runtime.concurrent.RemoteCallable;
import com.oracle.tools.runtime.concurrent.RemoteExecutorListener;
import com.oracle.tools.runtime.concurrent.RemoteRunnable;
import com.oracle.tools.runtime.concurrent.socket.SocketBasedRemoteExecutor;
import com.oracle.tools.util.CompletionListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class RemoteExecutorServer
extends AbstractControllableRemoteExecutor {
    private ServerSocket serverSocket = null;
    private Thread serverThread = null;
    private ConcurrentHashMap<Integer, SocketBasedRemoteExecutor> remoteExecutors = new ConcurrentHashMap();
    private AtomicBoolean isTerminating = new AtomicBoolean(false);

    public synchronized InetAddress open() throws IOException {
        if (!this.isOpen()) {
            this.serverSocket = new ServerSocket(0);
            this.serverSocket.setReuseAddress(true);
            this.serverThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    int channelId = 0;
                    while (!RemoteExecutorServer.this.isTerminating.get()) {
                        try {
                            Socket socket = RemoteExecutorServer.this.serverSocket.accept();
                            SocketBasedRemoteExecutor executor = new SocketBasedRemoteExecutor(++channelId, socket);
                            for (RemoteExecutorListener listener : RemoteExecutorServer.this.getListeners()) {
                                executor.addListener(listener);
                            }
                            RemoteExecutorServer.this.remoteExecutors.put(executor.getExecutorId(), executor);
                            executor.open();
                        }
                        catch (NullPointerException e) {
                            RemoteExecutorServer.this.isTerminating.compareAndSet(false, true);
                        }
                        catch (IOException e) {
                            RemoteExecutorServer.this.isTerminating.compareAndSet(false, true);
                        }
                    }
                }
            });
            this.serverThread.start();
            this.setOpen(true);
        }
        return this.getInetAddress((Predicate<InetAddress>)Predicates.allOf((Predicate[])new Predicate[]{NetworkHelper.LOOPBACK_ADDRESS, NetworkHelper.DEFAULT_ADDRESS}));
    }

    public synchronized int getPort() {
        if (this.serverSocket != null) {
            return this.serverSocket.getLocalPort();
        }
        throw new IllegalStateException("Server is closed");
    }

    public synchronized InetAddress getInetAddress(Predicate<InetAddress> predicate) {
        if (this.serverSocket != null) {
            try {
                predicate = predicate == null ? NetworkHelper.DEFAULT_ADDRESS : predicate;
                return NetworkHelper.getInetAddress(predicate);
            }
            catch (SocketException e) {
                return this.serverSocket.getInetAddress();
            }
        }
        throw new IllegalStateException("Server is closed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void onClose() {
        this.isTerminating.set(true);
        for (SocketBasedRemoteExecutor executor : this.remoteExecutors.values()) {
            try {
                executor.close();
            }
            catch (Exception exception) {}
        }
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
        }
        finally {
            this.serverSocket = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void submit(RemoteCallable<T> callable, CompletionListener<T> listener) throws IllegalStateException {
        RemoteExecutorServer remoteExecutorServer = this;
        synchronized (remoteExecutorServer) {
            if (this.isOpen() && !this.isTerminating.get()) {
                int submissionCount = 0;
                for (SocketBasedRemoteExecutor executor : this.remoteExecutors.values()) {
                    executor.submit(callable, listener);
                    ++submissionCount;
                }
                if (submissionCount == 0) {
                    throw new IllegalStateException("Failed to submit the request [" + callable + "].  There are no RemoteExecutors connected");
                }
            } else {
                throw new IllegalStateException("Can't submit the request [" + callable + " as the RemoteExecutor is closing or is closed");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submit(RemoteRunnable runnable) throws IllegalStateException {
        RemoteExecutorServer remoteExecutorServer = this;
        synchronized (remoteExecutorServer) {
            if (this.isOpen() && !this.isTerminating.get()) {
                int submissionCount = 0;
                for (SocketBasedRemoteExecutor executor : this.remoteExecutors.values()) {
                    executor.submit(runnable);
                    ++submissionCount;
                }
                if (submissionCount == 0) {
                    throw new IllegalStateException("Failed to submit the request [" + runnable + "].  There are no RemoteExecutors connected");
                }
            } else {
                throw new IllegalStateException("Can't submit the request [" + runnable + " as the RemoteExecutor is closing or is closed");
            }
        }
    }

    public Iterable<SocketBasedRemoteExecutor> getRemoteExecutors() {
        return this.remoteExecutors.values();
    }
}

