/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.runtime.concurrent.socket;

import com.oracle.tools.runtime.concurrent.AbstractControllableRemoteExecutor;
import com.oracle.tools.runtime.concurrent.RemoteCallable;
import com.oracle.tools.runtime.concurrent.RemoteExecutorListener;
import com.oracle.tools.runtime.concurrent.RemoteRunnable;
import com.oracle.tools.util.CompletionListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.Socket;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class SocketBasedRemoteExecutor
extends AbstractControllableRemoteExecutor {
    private int executorId;
    private Socket socket;
    private ObjectOutputStream output;
    private ObjectInputStream input;
    private ExecutorService executorService;
    private Thread requestAcceptorThread;
    private AtomicBoolean isReadable;
    private AtomicBoolean isWritable;
    private HashMap<String, Class<? extends Operation>> protocol;
    private ConcurrentHashMap<Long, CompletionListener<?>> pendingListeners;
    private AtomicLong nextSequenceNumber;

    public SocketBasedRemoteExecutor(int executorId, Socket socket) throws IOException {
        this.executorId = executorId;
        this.socket = socket;
        this.output = new ObjectOutputStream(socket.getOutputStream());
        this.input = new ObjectInputStream(socket.getInputStream());
        this.executorService = Executors.newSingleThreadExecutor();
        this.requestAcceptorThread = null;
        this.isReadable = new AtomicBoolean(true);
        this.isWritable = new AtomicBoolean(true);
        this.protocol = new HashMap();
        this.pendingListeners = new ConcurrentHashMap();
        this.nextSequenceNumber = new AtomicLong(0L);
        this.socket.setReuseAddress(true);
        this.protocol.put("CALLABLE", CallableOperation.class);
        this.protocol.put("RESPONSE", ResponseOperation.class);
        this.protocol.put("RUNNABLE", RunnableOperation.class);
    }

    public int getExecutorId() {
        return this.executorId;
    }

    public synchronized void open() {
        if (!this.isOpen()) {
            this.setOpen(true);
            this.requestAcceptorThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (SocketBasedRemoteExecutor.this.isReadable.get() && SocketBasedRemoteExecutor.this.isWritable.get()) {
                        try {
                            String operationType = SocketBasedRemoteExecutor.this.input.readUTF();
                            long sequence = SocketBasedRemoteExecutor.this.input.readLong();
                            int length = SocketBasedRemoteExecutor.this.input.readInt();
                            byte[] bytes = new byte[length];
                            SocketBasedRemoteExecutor.this.input.readFully(bytes, 0, length);
                            try {
                                ByteArrayInputStream buffer = new ByteArrayInputStream(bytes);
                                ObjectInputStream stream = new ObjectInputStream(buffer);
                                Class operationClass = (Class)SocketBasedRemoteExecutor.this.protocol.get(operationType);
                                Constructor constructor = operationClass.getConstructor(SocketBasedRemoteExecutor.class);
                                Operation operation = (Operation)constructor.newInstance(SocketBasedRemoteExecutor.this);
                                operation.read(stream);
                                SocketBasedRemoteExecutor.this.executorService.submit(new Executor(sequence, operation));
                            }
                            catch (Exception e) {
                                SocketBasedRemoteExecutor.this.executorService.submit(new Sender(sequence, new ResponseOperation(e)));
                            }
                        }
                        catch (Exception e) {
                            SocketBasedRemoteExecutor.this.isReadable.set(false);
                        }
                    }
                    SocketBasedRemoteExecutor.this.close();
                }
            });
            this.requestAcceptorThread.setName("RemoteExecutor:RequestAcceptor");
            this.requestAcceptorThread.setDaemon(true);
            this.requestAcceptorThread.start();
            for (RemoteExecutorListener listener : this.getListeners()) {
                try {
                    listener.onOpened(this);
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onClose() {
        this.isReadable.set(false);
        this.executorService.shutdown();
        this.isWritable.set(false);
        try {
            this.input.close();
        }
        catch (IOException e) {
        }
        finally {
            this.input = null;
        }
        try {
            this.output.close();
        }
        catch (IOException e) {
        }
        finally {
            this.output = null;
        }
        try {
            this.socket.close();
        }
        catch (IOException e) {
        }
        finally {
            this.socket = null;
        }
        for (CompletionListener<?> listener : this.pendingListeners.values()) {
            try {
                listener.onException((Exception)new IllegalStateException("RemoteExecutor is closed"));
            }
            catch (Exception exception) {}
        }
        this.pendingListeners.clear();
    }

    @Override
    public <T> void submit(RemoteCallable<T> callable, CompletionListener<T> listener) throws IllegalStateException {
        boolean isResponseRequired;
        long sequence;
        if (this.isOpen()) {
            sequence = this.nextSequenceNumber.getAndIncrement();
            boolean bl = isResponseRequired = listener != null;
            if (isResponseRequired) {
                this.pendingListeners.put(sequence, listener);
            }
        } else {
            throw new IllegalStateException("RemoteExecutor is closed");
        }
        CallableOperation operation = new CallableOperation(isResponseRequired, callable);
        this.executorService.submit(new Sender(sequence, operation));
    }

    @Override
    public void submit(RemoteRunnable runnable) throws IllegalStateException {
        if (!this.isOpen()) {
            throw new IllegalStateException("RemoteExecutor is closed");
        }
        long sequence = this.nextSequenceNumber.getAndIncrement();
        RunnableOperation operation = new RunnableOperation(runnable);
        this.executorService.submit(new Sender(sequence, operation));
    }

    class Sender
    implements Runnable {
        private long sequence;
        private Operation operation;

        public Sender(long sequence, Operation operation) {
            this.sequence = sequence;
            this.operation = operation;
        }

        @Override
        public void run() {
            try {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream(4096);
                ObjectOutputStream stream = new ObjectOutputStream(buffer);
                try {
                    this.operation.write(stream);
                }
                catch (NotSerializableException e) {
                    buffer.reset();
                    stream = new ObjectOutputStream(buffer);
                    this.operation = new ResponseOperation(e);
                    this.operation.write(stream);
                }
                stream.flush();
                SocketBasedRemoteExecutor.this.output.writeUTF(this.operation.getType());
                SocketBasedRemoteExecutor.this.output.writeLong(this.sequence);
                byte[] array = buffer.toByteArray();
                SocketBasedRemoteExecutor.this.output.writeInt(array.length);
                SocketBasedRemoteExecutor.this.output.write(array, 0, array.length);
                SocketBasedRemoteExecutor.this.output.flush();
            }
            catch (IOException e) {
                System.err.println("Failed to send Operation [" + this.operation + "], Sequence #" + this.sequence);
                e.printStackTrace();
            }
        }
    }

    class RunnableOperation
    implements Operation {
        private Runnable runnable;

        public RunnableOperation() {
        }

        public RunnableOperation(Runnable runnable) {
            if (runnable == null) {
                throw new NullPointerException("Runnable can't be null");
            }
            if (runnable.getClass().isAnonymousClass()) {
                throw new IllegalArgumentException("Runnable can't be an anonymous inner-class");
            }
            this.runnable = runnable;
        }

        @Override
        public String getType() {
            return "RUNNABLE";
        }

        @Override
        public Operation execute(long sequence) {
            try {
                this.runnable.run();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        @Override
        public void read(ObjectInputStream input) throws IOException {
            try {
                Object object = input.readObject();
                if (object instanceof String) {
                    String className = (String)object;
                    this.runnable = (Runnable)Class.forName(className).newInstance();
                } else {
                    this.runnable = (Runnable)object;
                }
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
            catch (InstantiationException e) {
                throw new IOException(e);
            }
            catch (IllegalAccessException e) {
                throw new IOException(e);
            }
        }

        @Override
        public void write(ObjectOutputStream output) throws IOException {
            if (this.runnable instanceof Serializable) {
                output.writeObject(this.runnable);
            } else {
                output.writeObject(this.runnable.getClass().getName());
            }
        }
    }

    class ResponseOperation
    implements Operation {
        private Object response;

        public ResponseOperation() {
        }

        public ResponseOperation(Object response) {
            this.response = response;
        }

        @Override
        public String getType() {
            return "RESPONSE";
        }

        @Override
        public Operation execute(long sequence) {
            CompletionListener listener = (CompletionListener)SocketBasedRemoteExecutor.this.pendingListeners.remove(sequence);
            if (listener != null) {
                try {
                    if (this.response instanceof Exception) {
                        listener.onException((Exception)this.response);
                    } else {
                        listener.onCompletion(this.response);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return null;
        }

        @Override
        public void read(ObjectInputStream input) throws IOException {
            try {
                this.response = input.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
        }

        @Override
        public void write(ObjectOutputStream output) throws IOException {
            output.writeObject(this.response);
        }

        public String toString() {
            return "ResponseOperation{response=" + this.response + "}";
        }
    }

    class Executor
    implements Runnable {
        private long sequence;
        private Operation operation;

        public Executor(long sequence, Operation operation) {
            this.sequence = sequence;
            this.operation = operation;
        }

        @Override
        public void run() {
            Operation resultingOperation = this.operation.execute(this.sequence);
            if (resultingOperation != null) {
                SocketBasedRemoteExecutor.this.executorService.submit(new Sender(this.sequence, resultingOperation));
            }
        }
    }

    class CallableOperation
    implements Operation {
        private boolean isResponseRequired;
        private Callable<?> callable;

        public CallableOperation() {
        }

        public CallableOperation(boolean isResponseRequired, Callable<?> callable) {
            if (callable == null) {
                throw new NullPointerException("Callable can't be null");
            }
            if (callable.getClass().isAnonymousClass()) {
                throw new IllegalArgumentException("Callable can't be an anonymous inner-class");
            }
            this.isResponseRequired = isResponseRequired;
            this.callable = callable;
        }

        @Override
        public String getType() {
            return "CALLABLE";
        }

        @Override
        public Operation execute(long sequence) {
            ResponseOperation operation;
            block3: {
                operation = null;
                try {
                    Object result = this.callable.call();
                    if (this.isResponseRequired) {
                        operation = new ResponseOperation(result);
                    }
                }
                catch (Exception e) {
                    if (!this.isResponseRequired) break block3;
                    operation = new ResponseOperation(e);
                }
            }
            return operation;
        }

        @Override
        public void read(ObjectInputStream input) throws IOException {
            this.isResponseRequired = input.readBoolean();
            try {
                Object object = input.readObject();
                if (object instanceof String) {
                    String className = (String)object;
                    Class<?> callableClass = Class.forName(className);
                    this.callable = (Callable)callableClass.newInstance();
                } else {
                    this.callable = (Callable)object;
                }
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
            catch (InstantiationException e) {
                throw new IOException(e);
            }
            catch (IllegalAccessException e) {
                throw new IOException(e);
            }
        }

        @Override
        public void write(ObjectOutputStream output) throws IOException {
            output.writeBoolean(this.isResponseRequired);
            if (this.callable instanceof Serializable) {
                output.writeObject(this.callable);
            } else {
                output.writeObject(this.callable.getClass().getName());
            }
        }
    }

    static interface Operation {
        public String getType();

        public void write(ObjectOutputStream var1) throws IOException;

        public void read(ObjectInputStream var1) throws IOException;

        public Operation execute(long var1);
    }
}

