/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.runtime.console;

import com.oracle.tools.runtime.ApplicationConsole;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.PrintWriter;
import java.io.Reader;

public abstract class AbstractPipedApplicationConsole
implements ApplicationConsole {
    public static final int DEFAULT_PIPE_SIZE = 1024;
    protected BufferedReader m_outputReader;
    protected PrintWriter m_outputWriter;
    protected PipedWriter m_outputPipedWriter;
    protected BufferedReader m_errorReader;
    protected PrintWriter m_errorWriter;
    protected PipedWriter m_errorPipedWriter;
    protected PipedReader m_inputReader;
    protected PrintWriter m_inputWriter;
    protected boolean m_diagnosticMode;

    public AbstractPipedApplicationConsole(int pipeSize, boolean diagnosticMode) throws IOException {
        PipedReader pipedOutputReader = new PipedReader(pipeSize);
        this.m_diagnosticMode = diagnosticMode;
        this.m_outputReader = new BufferedReader(pipedOutputReader);
        this.m_outputPipedWriter = new PipedWriter(pipedOutputReader);
        this.m_outputWriter = new PrintWriter(this.m_outputPipedWriter);
        PipedReader pipedErrorReader = new PipedReader(pipeSize);
        this.m_errorReader = new BufferedReader(pipedErrorReader);
        this.m_errorPipedWriter = new PipedWriter(pipedErrorReader);
        this.m_errorWriter = new PrintWriter(this.m_errorPipedWriter);
        this.m_inputReader = new PipedReader(pipeSize);
        this.m_inputWriter = new PrintWriter(new PipedWriter(this.m_inputReader));
    }

    @Override
    public PrintWriter getOutputWriter() {
        return this.m_outputWriter;
    }

    @Override
    public PrintWriter getErrorWriter() {
        return this.m_errorWriter;
    }

    @Override
    public Reader getInputReader() {
        return this.m_inputReader;
    }

    @Override
    public boolean isDiagnosticsEnabled() {
        return this.m_diagnosticMode;
    }

    @Override
    public void close() {
        try {
            this.m_inputReader.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.m_outputPipedWriter.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.m_errorPipedWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

