/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.runtime.console;

import com.oracle.tools.runtime.console.AbstractPipedApplicationConsole;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedList;

public class CapturingApplicationConsole
extends AbstractPipedApplicationConsole {
    private int m_maxLines;
    private LinkedList<String> m_outBuffer;
    private LinkedList<String> m_errBuffer;
    protected Thread m_outThread;
    protected Thread m_errThread;

    public CapturingApplicationConsole() throws IOException {
        this(Integer.MAX_VALUE, false, 1024);
    }

    public CapturingApplicationConsole(int maxLines) throws IOException {
        this(maxLines, false, 1024);
    }

    public CapturingApplicationConsole(int maxLines, boolean plainMode) throws IOException {
        this(maxLines, plainMode, 1024);
    }

    public CapturingApplicationConsole(int maxLines, boolean plainMode, int pipeSize) throws IOException {
        super(pipeSize, plainMode);
        this.m_maxLines = maxLines;
        this.m_outBuffer = new LinkedList();
        this.m_errBuffer = new LinkedList();
        this.m_outThread = new Thread(new OutputCaptor(this.m_outputReader, this.m_outBuffer));
        this.m_errThread = new Thread(new OutputCaptor(this.m_errorReader, this.m_errBuffer));
        this.m_outThread.start();
        this.m_errThread.start();
    }

    @Override
    public void close() {
        super.close();
        try {
            this.m_outThread.join();
            this.m_errThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public LinkedList<String> getCapturedOutputLines() {
        return this.m_outBuffer;
    }

    public LinkedList<String> getCapturedErrorLines() {
        return this.m_errBuffer;
    }

    public PrintWriter getInputWriter() {
        return this.m_inputWriter;
    }

    class OutputCaptor
    implements Runnable {
        BufferedReader reader;
        LinkedList<String> lines;

        OutputCaptor(BufferedReader reader, LinkedList<String> lines) {
            this.reader = reader;
            this.lines = lines;
        }

        @Override
        public void run() {
            try {
                String line = this.reader.readLine();
                while (line != null) {
                    if (this.lines.size() >= CapturingApplicationConsole.this.m_maxLines) {
                        this.lines.poll();
                    }
                    this.lines.add(line);
                    line = this.reader.readLine();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

