/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.runtime.java;

import com.oracle.tools.deferred.Cached;
import com.oracle.tools.deferred.Deferred;
import com.oracle.tools.deferred.DeferredHelper;
import com.oracle.tools.deferred.NeverAvailable;
import com.oracle.tools.deferred.PermanentlyUnavailableException;
import com.oracle.tools.deferred.TimeoutConstraint;
import com.oracle.tools.deferred.jmx.DeferredJMXConnector;
import com.oracle.tools.deferred.jmx.DeferredMBeanAttribute;
import com.oracle.tools.deferred.jmx.DeferredMBeanInfo;
import com.oracle.tools.deferred.jmx.DeferredMBeanProxy;
import com.oracle.tools.options.Timeout;
import com.oracle.tools.runtime.AbstractApplication;
import com.oracle.tools.runtime.LifecycleEventInterceptor;
import com.oracle.tools.runtime.Platform;
import com.oracle.tools.runtime.concurrent.RemoteCallable;
import com.oracle.tools.runtime.concurrent.RemoteRunnable;
import com.oracle.tools.runtime.concurrent.callable.RemoteMethodInvocation;
import com.oracle.tools.runtime.java.FluentJavaApplication;
import com.oracle.tools.runtime.java.JavaApplicationProcess;
import com.oracle.tools.runtime.java.JavaApplicationRuntime;
import com.oracle.tools.runtime.network.Constants;
import com.oracle.tools.util.CompletionListener;
import com.oracle.tools.util.FutureCompletionListener;
import com.oracle.tools.util.ReflectionHelper;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Properties;
import java.util.Set;
import javax.management.MBeanInfo;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.remote.JMXConnector;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;

public abstract class AbstractJavaApplication<A extends AbstractJavaApplication<A, P, R>, P extends JavaApplicationProcess, R extends JavaApplicationRuntime<P>>
extends AbstractApplication<A, P, R>
implements FluentJavaApplication<A> {
    protected Cached<JMXConnector> cachedJmxConnector;

    public AbstractJavaApplication(R runtime, Iterable<LifecycleEventInterceptor<? super A>> interceptors) {
        super(runtime, interceptors);
        System.setProperty("java.rmi.server.useCodebaseOnly", "true");
        if (this.isJMXEnabled()) {
            String url = String.format("service:jmx:rmi:///jndi/rmi://%s:%d/jmxrmi", this.getRMIServerHostName(), this.getRemoteJMXPort());
            this.cachedJmxConnector = DeferredHelper.cached((Deferred)new DeferredJMXConnector(url));
        } else {
            this.cachedJmxConnector = DeferredHelper.cached((Deferred)new NeverAvailable(JMXConnector.class));
        }
    }

    public <T> T submit(RemoteCallable<T> callable) {
        FutureCompletionListener future = new FutureCompletionListener();
        this.submit(callable, (CompletionListener<T>)future);
        try {
            return (T)future.get();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to execute the Callable: " + callable, e);
        }
    }

    @Override
    public Properties getSystemProperties() {
        return ((JavaApplicationRuntime)this.runtime).getSystemProperties();
    }

    @Override
    public String getSystemProperty(String name) {
        return this.getSystemProperties().getProperty(name);
    }

    @Override
    public boolean isJMXEnabled() {
        return this.getSystemProperties().containsKey("com.sun.management.jmxremote.port");
    }

    @Override
    public int getRemoteJMXPort() {
        if (this.isJMXEnabled()) {
            return Integer.parseInt(this.getSystemProperties().getProperty("com.sun.management.jmxremote.port"));
        }
        throw new UnsupportedOperationException("Application is not enabled for remote JMX management");
    }

    @Override
    public String getRMIServerHostName() {
        String hostname = this.getSystemProperties().getProperty("java.rmi.server.hostname");
        return hostname == null ? Constants.getLocalHost() : hostname;
    }

    @Override
    public Deferred<JMXConnector> getDeferredJMXConnector() {
        return this.cachedJmxConnector;
    }

    @Override
    public <T> Deferred<T> getDeferredMBeanProxy(ObjectName objectName, Class<T> proxyClass) {
        return new Cached((Deferred)new DeferredMBeanProxy(this.cachedJmxConnector, objectName, proxyClass));
    }

    @Override
    public <T> T getMBeanProxy(ObjectName objectName, Class<T> proxyClass) {
        return (T)DeferredHelper.ensured(this.getDeferredMBeanProxy(objectName, proxyClass), (TimeoutConstraint)DeferredHelper.within((Timeout)this.getDefaultTimeout())).get();
    }

    @Override
    public Deferred<MBeanInfo> getDeferredMBeanInfo(ObjectName objectName) {
        return new DeferredMBeanInfo(this.cachedJmxConnector, objectName);
    }

    @Override
    public MBeanInfo getMBeanInfo(ObjectName objectName) {
        return (MBeanInfo)DeferredHelper.ensured(this.getDeferredMBeanInfo(objectName), (TimeoutConstraint)DeferredHelper.within((Timeout)this.getDefaultTimeout())).get();
    }

    @Override
    public <T> Deferred<T> getDeferredMBeanAttribute(ObjectName objectName, String attributeName, Class<T> attributeClass) {
        return new DeferredMBeanAttribute(this.cachedJmxConnector, objectName, attributeName, attributeClass);
    }

    @Override
    public <T> T getMBeanAttribute(ObjectName objectName, String attributeName, Class<T> attributeClass) {
        return (T)DeferredHelper.ensured(this.getDeferredMBeanAttribute(objectName, attributeName, attributeClass), (TimeoutConstraint)DeferredHelper.within((Timeout)this.getDefaultTimeout())).get();
    }

    @Override
    public Set<ObjectInstance> queryMBeans(ObjectName name, QueryExp query) {
        try {
            return ((JMXConnector)DeferredHelper.ensured(this.getDeferredJMXConnector(), (TimeoutConstraint)DeferredHelper.within((Timeout)this.getDefaultTimeout())).get()).getMBeanServerConnection().queryMBeans(name, query);
        }
        catch (IOException e) {
            throw new PermanentlyUnavailableException(this.getDeferredJMXConnector(), (Throwable)e);
        }
    }

    @Override
    public <T> void submit(RemoteCallable<T> callable, CompletionListener<T> listener) {
        ((JavaApplicationProcess)((JavaApplicationRuntime)this.runtime).getApplicationProcess()).submit(callable, listener);
    }

    @Override
    public void submit(RemoteRunnable runnable) throws IllegalStateException {
        ((JavaApplicationProcess)((JavaApplicationRuntime)this.runtime).getApplicationProcess()).submit(runnable);
    }

    @Override
    public void close() {
        JMXConnector jmxConnector = (JMXConnector)this.cachedJmxConnector.release();
        if (jmxConnector != null) {
            try {
                jmxConnector.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.close();
    }

    @Override
    public InetSocketAddress getRemoteDebugSocket() {
        int remoteDebuggingPort = ((JavaApplicationRuntime)this.runtime).getRemoteDebuggingPort();
        if (remoteDebuggingPort <= 0) {
            return null;
        }
        Platform platform = this.getPlatform();
        if (platform == null) {
            return null;
        }
        InetAddress address = platform.getPublicInetAddress();
        return new InetSocketAddress(address, remoteDebuggingPort);
    }

    @Override
    public <T> T getProxyFor(Class<T> classToProxy, RemoteCallable<T> instanceProducer, RemoteMethodInvocation.Interceptor interceptor) {
        return (T)ReflectionHelper.createProxyOf(classToProxy, new ProxyMethodInterceptor<T>(instanceProducer, interceptor));
    }

    private class ProxyMethodInterceptor<T>
    implements MethodInterceptor {
        private RemoteCallable<T> instanceProducer;
        private RemoteMethodInvocation.Interceptor interceptor;

        public ProxyMethodInterceptor(RemoteCallable<T> instanceProducer, RemoteMethodInvocation.Interceptor interceptor) {
            this.instanceProducer = instanceProducer;
            this.interceptor = interceptor;
        }

        public Object intercept(Object self, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            if (this.interceptor != null) {
                this.interceptor.onBeforeRemoteInvocation(method, args);
            }
            FutureCompletionListener listener = new FutureCompletionListener();
            AbstractJavaApplication.this.submit(new RemoteMethodInvocation<T>(this.instanceProducer, method.getName(), args, this.interceptor), listener);
            try {
                Object result = listener.get();
                if (this.interceptor != null) {
                    result = this.interceptor.onAfterRemoteInvocation(method, args, result);
                }
                return result;
            }
            catch (Exception e) {
                if (this.interceptor == null) {
                    throw e;
                }
                throw this.interceptor.onRemoteInvocationException(method, args, e);
            }
        }
    }
}

