/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.runtime.java;

import com.oracle.tools.runtime.AbstractApplicationSchema;
import com.oracle.tools.runtime.LocalPlatform;
import com.oracle.tools.runtime.Platform;
import com.oracle.tools.runtime.PropertiesBuilder;
import com.oracle.tools.runtime.java.ClassPath;
import com.oracle.tools.runtime.java.FluentJavaApplicationSchema;
import com.oracle.tools.runtime.java.JavaApplication;
import com.oracle.tools.runtime.java.JavaApplicationSchema;
import com.oracle.tools.runtime.network.AvailablePortIterator;
import java.util.Properties;

public abstract class AbstractJavaApplicationSchema<A extends JavaApplication, S extends AbstractJavaApplicationSchema<A, S>>
extends AbstractApplicationSchema<A, S>
implements FluentJavaApplicationSchema<A, S> {
    private String applicationClassName;
    private ClassPath classPath;
    private PropertiesBuilder systemPropertiesBuilder;

    public AbstractJavaApplicationSchema(JavaApplicationSchema<A> schema) {
        super(schema);
        this.applicationClassName = schema.getApplicationClassName();
        this.classPath = new ClassPath(schema.getClassPath());
        this.systemPropertiesBuilder = new PropertiesBuilder(schema.getSystemPropertiesBuilder());
        this.configureDefaults();
    }

    public AbstractJavaApplicationSchema(String applicationClassName) {
        this("java", applicationClassName, System.getProperty("java.class.path"));
    }

    public AbstractJavaApplicationSchema(String applicationClassName, String classPath) {
        this("java", applicationClassName, classPath);
    }

    public AbstractJavaApplicationSchema(String executableName, String applicationClassName, String classPath) {
        super(executableName);
        this.applicationClassName = applicationClassName;
        this.classPath = new ClassPath(classPath);
        this.systemPropertiesBuilder = new PropertiesBuilder();
        this.configureDefaults();
    }

    protected abstract void configureDefaults();

    @Override
    public PropertiesBuilder getSystemPropertiesBuilder() {
        return this.systemPropertiesBuilder;
    }

    @Override
    public Properties getSystemProperties(Platform platform) {
        return this.getSystemPropertiesBuilder().realize(null, platform);
    }

    @Override
    public ClassPath getClassPath() {
        return this.classPath;
    }

    @Override
    public String getApplicationClassName() {
        return this.applicationClassName;
    }

    @Override
    public S setApplicationClassName(String className) {
        this.applicationClassName = className;
        return (S)this;
    }

    public S setClassPath(String classPath) {
        this.classPath = new ClassPath(classPath);
        return (S)this;
    }

    public S setClassPath(ClassPath classPath) {
        this.classPath = classPath;
        return (S)this;
    }

    public S setSystemProperty(String name, Object value) {
        this.systemPropertiesBuilder.setProperty(name, value);
        return (S)this;
    }

    public <T> T getSystemProperty(String name, Class<T> propertyClass, T defaultValue) {
        if (this.systemPropertiesBuilder.containsProperty(name)) {
            Object property = this.systemPropertiesBuilder.getProperty(name);
            return propertyClass.cast(property);
        }
        return defaultValue;
    }

    public S setSystemPropertyIfAbsent(String name, Object value) {
        this.systemPropertiesBuilder.setPropertyIfAbsent(name, value);
        return (S)this;
    }

    @Deprecated
    public S setDefaultSystemProperty(String name, Object value) {
        this.systemPropertiesBuilder.setDefaultProperty(name, value);
        return (S)this;
    }

    public S setSystemProperties(PropertiesBuilder systemProperties) {
        this.systemPropertiesBuilder.addProperties(systemProperties);
        return (S)this;
    }

    public S setJMXSupport(boolean enabled) {
        if (enabled) {
            this.setSystemProperty("com.sun.management.jmxremote", "");
            this.setSystemPropertyIfAbsent("com.sun.management.jmxremote.port", 9000);
            this.setSystemPropertyIfAbsent("com.sun.management.jmxremote.authenticate", false);
            this.setSystemPropertyIfAbsent("com.sun.management.jmxremote.ssl", false);
            this.setSystemPropertyIfAbsent("java.rmi.server.hostname", LocalPlatform.getInstance().getHostName());
        } else {
            this.systemPropertiesBuilder.removeProperty("com.sun.management.jmxremote");
            this.systemPropertiesBuilder.removeProperty("com.sun.management.jmxremote.port");
            this.systemPropertiesBuilder.removeProperty("com.sun.management.jmxremote.authenticate");
            this.systemPropertiesBuilder.removeProperty("com.sun.management.jmxremote.ssl");
            this.systemPropertiesBuilder.removeProperty("java.rmi.server.hostname");
        }
        return (S)this;
    }

    public S setPreferIPv4(boolean enabled) {
        return this.setSystemProperty("java.net.preferIPv4Stack", enabled);
    }

    @Override
    public boolean isIPv4Preferred() {
        if (this.systemPropertiesBuilder.containsProperty("java.net.preferIPv4Stack")) {
            Object isIPv4Preferred = this.systemPropertiesBuilder.getProperty("java.net.preferIPv4Stack");
            return isIPv4Preferred == null ? false : Boolean.valueOf(isIPv4Preferred.toString());
        }
        return false;
    }

    public S setJMXAuthentication(boolean enabled) {
        return this.setSystemProperty("com.sun.management.jmxremote.authenticate", enabled);
    }

    public S setJMXPort(int port) {
        return this.setSystemProperty("com.sun.management.jmxremote.port", port);
    }

    public S setJMXPort(AvailablePortIterator portIterator) {
        return this.setSystemProperty("com.sun.management.jmxremote.port", portIterator);
    }

    public S setRMIServerHostName(String rmiServerHostName) {
        this.setSystemProperty("java.rmi.server.hostname", rmiServerHostName);
        return (S)this;
    }

    public S setHeadless(boolean isHeadless) {
        this.setSystemProperty("java.awt.headless", isHeadless);
        return (S)this;
    }

    public boolean isHeadless() {
        Object value = this.systemPropertiesBuilder.getProperty("java.awt.headless");
        return value instanceof Boolean && (Boolean)value != false;
    }
}

