/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.runtime.java;

import com.oracle.tools.lang.StringHelper;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;

public class ClassPath
implements Iterable<String> {
    public static final String[] JAVA_ARCHIVE_TYPES = new String[]{"aar", "car", "ear", "gar", "jar", "rar", "sar", "war", "zip"};
    private final ArrayList<String> paths = new ArrayList();
    private String fileSeparator = File.separator;
    private String pathSeparator = File.pathSeparator;

    public ClassPath() {
    }

    public ClassPath(ClassPath ... classPaths) {
        if (classPaths != null && classPaths.length > 0) {
            for (ClassPath classPath : classPaths) {
                for (String path : classPath) {
                    path = ClassPath.sanitizePath(path);
                    this.paths.add(path);
                }
            }
        }
    }

    public ClassPath(Iterable<ClassPath> classPaths) {
        if (classPaths != null) {
            for (ClassPath classPath : classPaths) {
                for (String path : classPath) {
                    path = ClassPath.sanitizePath(path);
                    this.paths.add(path);
                }
            }
        }
    }

    public ClassPath(String ... classPaths) {
        if (classPaths != null) {
            for (String classPath : classPaths) {
                String[] paths;
                classPath = classPath == null ? "" : classPath.trim();
                if ((classPath = StringHelper.dequote((String)classPath)).isEmpty()) continue;
                for (String path : paths = classPath.split(this.pathSeparator)) {
                    if ((path = ClassPath.sanitizePath(path)).isEmpty()) continue;
                    this.paths.add(path);
                }
            }
        }
    }

    public int size() {
        return this.paths.size();
    }

    public boolean isEmpty() {
        return this.paths.isEmpty();
    }

    public URL[] getURLs() {
        URL[] urls = new URL[this.paths.size()];
        int i = 0;
        for (String path : this.paths) {
            try {
                urls[i++] = new File(path).toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Failed to convert the path [" + path + "] into a URL", e);
            }
        }
        return urls;
    }

    public boolean contains(String path) {
        if (path == null) {
            return false;
        }
        path = ClassPath.sanitizePath(path);
        for (String aPath : this.paths) {
            if (!aPath.equals(path)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(ClassPath classPath) {
        if (classPath == null) {
            return false;
        }
        for (String path : classPath) {
            if (this.contains(path)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<String> iterator() {
        return this.paths.iterator();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (String path : this.paths) {
            if (builder.length() > 0) {
                builder.append(this.pathSeparator);
            }
            builder.append(path);
        }
        return builder.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ClassPath classPath = (ClassPath)other;
        return this.paths.equals(classPath.paths);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private static String sanitizePath(String path) {
        if (path == null) {
            return "";
        }
        path = path.trim();
        if (!(path = StringHelper.unquote((String)path)).isEmpty()) {
            path = ClassPath.isResourceAnArchive(path) || path.endsWith(File.separator) || path.endsWith("*") ? path : path + File.separator;
        }
        return path;
    }

    public static boolean isResourceAnArchive(String resourceName) {
        return ClassPath.getResourceArchiveType(resourceName) != null;
    }

    public static String getResourceArchiveType(String resourceName) {
        String extension;
        resourceName = resourceName == null ? "" : resourceName.trim();
        int index = resourceName.lastIndexOf(".");
        if (index >= 0 && (index = Arrays.binarySearch(JAVA_ARCHIVE_TYPES, extension = resourceName.substring(index + 1).toLowerCase())) >= 0) {
            return JAVA_ARCHIVE_TYPES[index];
        }
        for (String archiveType : JAVA_ARCHIVE_TYPES) {
            if (!resourceName.startsWith(archiveType + ":")) continue;
            return archiveType;
        }
        return null;
    }

    public static ClassPath ofResource(String resourceName, ClassLoader classLoader) throws IOException {
        if (resourceName == null) {
            throw new NullPointerException("Resource name must not be null");
        }
        Enumeration<URL> resources = (classLoader = classLoader == null ? Thread.currentThread().getContextClassLoader() : classLoader).getResources(resourceName);
        if (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            String location = URLDecoder.decode(url.toExternalForm(), "UTF-8");
            location = location.replace(" ", "%20");
            String archiveType = ClassPath.getResourceArchiveType(location = location.substring(0, location.length() - resourceName.length() - 1));
            if (archiveType != null && location.startsWith(archiveType + ":")) {
                location = location.substring(archiveType.length() + 1, location.length() - 1);
            }
            try {
                return new ClassPath(new File(new URI(location)).getAbsolutePath());
            }
            catch (URISyntaxException e) {
                throw new IOException("Unable to create a ClassPath for [" + location + "] using ClassLoader [" + classLoader + "] as an illegal URI was encountered", e);
            }
        }
        throw new IOException("Unable to locate the specified resource [" + resourceName + "] using ClassLoader [" + classLoader + "] with ClassPath [" + ClassPath.ofSystem() + "]");
    }

    public static ClassPath ofResource(String resourceName) throws IOException {
        return ClassPath.ofResource(resourceName, Thread.currentThread().getContextClassLoader());
    }

    public static ClassPath ofClass(Class<?> clazz) throws IOException {
        if (clazz == null) {
            throw new NullPointerException("Class must not be null");
        }
        String resourceName = clazz.getCanonicalName().replace(".", "/") + ".class";
        return ClassPath.ofResource(resourceName, clazz.getClassLoader());
    }

    public static ClassPath ofFile(File file) {
        if (file == null) {
            throw new NullPointerException("File must not be null");
        }
        return new ClassPath(file.toString());
    }

    public static ClassPath ofSystem() {
        return new ClassPath(System.getProperty("java.class.path"));
    }

    public static ClassPath of(Iterable<String> paths) {
        if (paths == null) {
            return new ClassPath();
        }
        ArrayList<ClassPath> classPaths = new ArrayList<ClassPath>();
        for (String path : paths) {
            classPaths.add(new ClassPath(path));
        }
        return new ClassPath(classPaths);
    }
}

