/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.runtime.java;

import com.oracle.tools.Option;
import com.oracle.tools.Options;
import com.oracle.tools.runtime.Application;
import com.oracle.tools.runtime.ApplicationConsole;
import com.oracle.tools.runtime.ApplicationSchema;
import com.oracle.tools.runtime.Platform;
import com.oracle.tools.runtime.PropertiesBuilder;
import com.oracle.tools.runtime.concurrent.RemoteCallable;
import com.oracle.tools.runtime.concurrent.RemoteExecutor;
import com.oracle.tools.runtime.concurrent.RemoteRunnable;
import com.oracle.tools.runtime.concurrent.callable.RemoteCallableStaticMethod;
import com.oracle.tools.runtime.java.AbstractJavaApplicationBuilder;
import com.oracle.tools.runtime.java.JavaApplication;
import com.oracle.tools.runtime.java.JavaApplicationProcess;
import com.oracle.tools.runtime.java.JavaApplicationSchema;
import com.oracle.tools.runtime.java.container.Container;
import com.oracle.tools.runtime.java.container.ContainerClassLoader;
import com.oracle.tools.runtime.java.container.ContainerScope;
import com.oracle.tools.runtime.java.io.Serialization;
import com.oracle.tools.util.CompletionListener;
import com.oracle.tools.util.FutureCompletionListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ContainerBasedJavaApplicationBuilder<A extends JavaApplication>
extends AbstractJavaApplicationBuilder<A> {
    private static Logger LOGGER = Logger.getLogger(ContainerBasedJavaApplicationBuilder.class.getName());

    protected <T extends A, S extends ApplicationSchema<T>> void sanityCheck(S schema, Properties schemaProperties) {
        String schemaPreferIPv4Stack = schemaProperties.getProperty("java.net.preferIPv4Stack");
        schemaPreferIPv4Stack = schemaPreferIPv4Stack == null ? "" : schemaPreferIPv4Stack.trim().toLowerCase();
        String systemPreferIPv4Stack = System.getProperty("java.net.preferIPv4Stack");
        String string = systemPreferIPv4Stack = systemPreferIPv4Stack == null ? "" : systemPreferIPv4Stack.trim().toLowerCase();
        if (systemPreferIPv4Stack.isEmpty() && !schemaPreferIPv4Stack.isEmpty()) {
            LOGGER.warning("The schema [" + schema + "] defines the " + "java.net.preferIPv4Stack" + " system property but it is not defined by the current process." + "Container-based applications requiring this system property must have it defined at the operating system level." + "eg: In your case it should be defined as; -D" + "java.net.preferIPv4Stack" + "=" + schemaPreferIPv4Stack);
        } else if (!systemPreferIPv4Stack.equals(schemaPreferIPv4Stack)) {
            LOGGER.warning("The schema [" + schema + "] defines the " + "java.net.preferIPv4Stack" + " system property but it is not defined by the current process in the same manner." + "Container-based applications requiring this system property must have it in the same manner at the operating system level." + "eg: In your case it should be defined as; -D" + "java.net.preferIPv4Stack" + "=" + schemaPreferIPv4Stack);
        }
    }

    @Override
    public <T extends A, S extends ApplicationSchema<T>> T realize(S applicationSchema, String applicationName, ApplicationConsole console, Platform platform, Option ... applicationOptions) {
        Options options = applicationSchema.getPlatformSpecificOptions(platform);
        options.addAll(applicationOptions);
        JavaApplicationSchema schema = (JavaApplicationSchema)applicationSchema;
        try {
            ApplicationController controller;
            Properties systemProperties = schema.getSystemProperties(platform);
            this.sanityCheck(schema, systemProperties);
            ContainerClassLoader classLoader = ContainerClassLoader.newInstance(applicationName, schema.getClassPath(), systemProperties);
            if (schema instanceof ApplicationController) {
                controller = (ApplicationController)((Object)schema);
            } else {
                controller = new StandardController(schema.getApplicationClassName(), schema.getArguments());
                Class<?> applicationClass = classLoader.loadClass(schema.getApplicationClassName());
            }
            ContainerBasedJavaApplicationProcess process = new ContainerBasedJavaApplicationProcess(classLoader, controller);
            Container.manage(classLoader.getContainerScope());
            process.start();
            Properties environmentVariables = PropertiesBuilder.fromCurrentEnvironmentVariables().realize();
            Object application = schema.createJavaApplication(process, applicationName, platform, options, console, environmentVariables, systemProperties, -1);
            this.raiseApplicationLifecycleEvent(application, Application.EventKind.REALIZED);
            return (T)application;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to start ContainerBasedJavaProcess", e);
        }
    }

    public static class StandardController
    implements ApplicationController {
        private String applicationClassName;
        private List<String> arguments;

        public StandardController(String applicationClassName, List<String> arguments) {
            this.applicationClassName = applicationClassName;
            this.arguments = arguments == null ? new ArrayList<String>(0) : new ArrayList<String>(arguments);
        }

        public String getApplicationClassName() {
            return this.applicationClassName;
        }

        public List<String> getArguments() {
            return new ArrayList<String>(this.arguments);
        }

        @Override
        public void start(ControllableApplication application, CompletionListener<Void> listener) {
            RemoteCallableStaticMethod callable = new RemoteCallableStaticMethod(this.applicationClassName, "main", this.arguments);
            application.submit(callable, listener);
        }

        @Override
        public void destroy(ControllableApplication application, CompletionListener<Void> listener) {
            if (listener != null) {
                listener.onCompletion(null);
            }
        }
    }

    public static class NullController
    implements ApplicationController {
        @Override
        public void start(ControllableApplication application, CompletionListener<Void> listener) {
            if (listener != null) {
                listener.onCompletion(null);
            }
        }

        @Override
        public void destroy(ControllableApplication application, CompletionListener<Void> listener) {
            if (listener != null) {
                listener.onCompletion(null);
            }
        }
    }

    public static class CustomController
    implements ApplicationController {
        private RemoteCallableStaticMethod<Void> m_callableStartStaticMethod;
        private RemoteCallableStaticMethod<Void> m_callableDestroyStaticMethod;

        public CustomController(RemoteCallableStaticMethod<Void> callableStartStaticMethod) {
            this(callableStartStaticMethod, null);
        }

        public CustomController(RemoteCallableStaticMethod<Void> callableStartStaticMethod, RemoteCallableStaticMethod<Void> callableDestroyStaticMethod) {
            this.m_callableStartStaticMethod = callableStartStaticMethod;
            this.m_callableDestroyStaticMethod = callableDestroyStaticMethod;
        }

        @Override
        public void start(ControllableApplication application, CompletionListener<Void> listener) {
            if (this.m_callableStartStaticMethod == null) {
                if (listener != null) {
                    listener.onCompletion(null);
                }
            } else {
                application.submit(this.m_callableStartStaticMethod, listener);
            }
        }

        @Override
        public void destroy(ControllableApplication application, CompletionListener<Void> listener) {
            if (this.m_callableDestroyStaticMethod == null) {
                if (listener != null) {
                    listener.onCompletion(null);
                }
            } else {
                application.submit(this.m_callableDestroyStaticMethod, listener);
            }
        }
    }

    public static class ContainerBasedJavaApplicationProcess
    implements JavaApplicationProcess,
    ControllableApplication {
        private ExecutorService m_executorService;
        private ContainerClassLoader m_classLoader;
        private ApplicationController m_controller;
        private FutureCompletionListener<Void> m_startListener;
        private FutureCompletionListener<Void> m_destroyListener;

        public ContainerBasedJavaApplicationProcess(ContainerClassLoader classLoader, ApplicationController controller) {
            if (controller == null) {
                throw new NullPointerException("ApplicationController must not be null");
            }
            this.m_executorService = Executors.newCachedThreadPool();
            this.m_classLoader = classLoader;
            this.m_controller = controller;
        }

        @Override
        public ClassLoader getClassLoader() {
            return this.m_classLoader;
        }

        @Override
        public long getId() {
            return -1L;
        }

        @Override
        public OutputStream getOutputStream() {
            return this.m_classLoader.getContainerScope().getStandardInputOutputStream();
        }

        @Override
        public InputStream getInputStream() {
            return this.m_classLoader.getContainerScope().getStandardOutputInputStream();
        }

        @Override
        public InputStream getErrorStream() {
            return this.m_classLoader.getContainerScope().getStandardErrorInputStream();
        }

        @Override
        public int waitFor() {
            if (this.m_controller != null) {
                try {
                    if (this.m_startListener != null) {
                        this.m_startListener.get();
                    }
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Interrupted while waiting for application to terminate", e);
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e.getCause());
                }
            }
            return 0;
        }

        @Override
        public int exitValue() {
            return 0;
        }

        public void start() {
            if (this.m_controller == null) {
                this.m_startListener = null;
            } else {
                this.m_startListener = new FutureCompletionListener();
                this.m_controller.start(this, (CompletionListener<Void>)this.m_startListener);
            }
        }

        @Override
        public void close() {
            if (this.m_controller != null) {
                try {
                    this.m_destroyListener = new FutureCompletionListener();
                    this.m_controller.destroy(this, (CompletionListener<Void>)this.m_destroyListener);
                    this.m_destroyListener.get();
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "An exception occurred while closing the application", e);
                }
                this.m_controller = null;
            }
            ContainerScope scope = this.m_classLoader.getContainerScope();
            scope.close();
            Container.unmanage(scope);
        }

        @Override
        @Deprecated
        public void destroy() {
            this.close();
        }

        @Override
        public <T> void submit(RemoteCallable<T> callable, final CompletionListener<T> listener) {
            if (this.m_controller == null) {
                IllegalStateException e = new IllegalStateException("Attempting to submit to a ContainerBasedJavaProcess that has been destroyed");
                if (listener != null) {
                    listener.onException((Exception)e);
                }
                throw e;
            }
            try {
                final byte[] serializedCallable = Serialization.toByteArray(callable);
                Runnable scopedRunnable = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
                        try {
                            Thread.currentThread().setContextClassLoader(ContainerBasedJavaApplicationProcess.this.m_classLoader);
                            Container.associateThreadWith(ContainerBasedJavaApplicationProcess.this.m_classLoader.getContainerScope());
                            Callable callable = Serialization.fromByteArray(serializedCallable, Callable.class, ContainerBasedJavaApplicationProcess.this.m_classLoader);
                            Object result = callable.call();
                            byte[] serializedResult = Serialization.toByteArray(result);
                            if (listener != null) {
                                listener.onCompletion(Serialization.fromByteArray(serializedResult, Object.class, originalClassLoader));
                            }
                        }
                        catch (Exception e) {
                            if (listener != null) {
                                listener.onException(e);
                            }
                        }
                        finally {
                            Container.dissociateThread();
                            Thread.currentThread().setContextClassLoader(originalClassLoader);
                        }
                    }
                };
                this.m_executorService.submit(scopedRunnable);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to serialize the Callable: " + callable, e);
            }
        }

        @Override
        public void submit(RemoteRunnable runnable) throws IllegalStateException {
            if (this.m_controller == null) {
                throw new IllegalStateException("Attempting to submit to a ContainerBasedJavaProcess that has been destroyed");
            }
            try {
                final byte[] serializedRunnable = Serialization.toByteArray(runnable);
                Runnable scopedRunnable = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
                        try {
                            Thread.currentThread().setContextClassLoader(ContainerBasedJavaApplicationProcess.this.m_classLoader);
                            Container.associateThreadWith(ContainerBasedJavaApplicationProcess.this.m_classLoader.getContainerScope());
                            Runnable runnable = Serialization.fromByteArray(serializedRunnable, Runnable.class, ContainerBasedJavaApplicationProcess.this.m_classLoader);
                            runnable.run();
                        }
                        catch (IOException iOException) {
                        }
                        finally {
                            Container.dissociateThread();
                            Thread.currentThread().setContextClassLoader(originalClassLoader);
                        }
                    }
                };
                this.m_executorService.submit(scopedRunnable);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to serialize the Runnable: " + runnable, e);
            }
        }
    }

    public static interface ControllableApplication
    extends RemoteExecutor {
        public ClassLoader getClassLoader();
    }

    public static interface ApplicationController {
        public void start(ControllableApplication var1, CompletionListener<Void> var2);

        public void destroy(ControllableApplication var1, CompletionListener<Void> var2);
    }
}

