/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.runtime.java;

import com.oracle.tools.runtime.concurrent.RemoteExecutor;
import com.oracle.tools.runtime.concurrent.RemoteExecutorListener;
import com.oracle.tools.runtime.concurrent.socket.RemoteExecutorClient;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicBoolean;

public class JavaApplicationLauncher {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] arguments) {
        if (arguments.length == 0) {
            System.exit(-1);
        } else {
            String address = System.getProperty("oracletools.runtime.parent.address", null);
            Integer port = Integer.getInteger("oracletools.runtime.parent.port", null);
            final boolean isOrphanable = Boolean.getBoolean("oracletools.runtime.orphanable");
            final AtomicBoolean isTerminating = new AtomicBoolean(false);
            if (address == null) {
                System.exit(-1);
            } else if (port == null) {
                System.exit(-1);
            } else if (arguments.length >= 1) {
                RemoteExecutorClient remoteExecutor;
                String applicationClassName;
                block35: {
                    applicationClassName = arguments[0];
                    remoteExecutor = null;
                    try {
                        InetAddress inetAddress = InetAddress.getByName(address);
                        remoteExecutor = new RemoteExecutorClient(inetAddress, port);
                        remoteExecutor.addListener(new RemoteExecutorListener(){

                            @Override
                            public void onOpened(RemoteExecutor executor) {
                            }

                            @Override
                            public void onClosed(RemoteExecutor executor) {
                                if (!isTerminating.get() && !isOrphanable) {
                                    System.exit(-2);
                                }
                            }
                        });
                        remoteExecutor.open();
                    }
                    catch (UnknownHostException e) {
                        System.out.println("JavaApplicationLauncher: The specified parent address is unknown");
                        e.printStackTrace(System.out);
                    }
                    catch (IOException e) {
                        System.out.println("JavaApplicationLauncher: Failed to open a connection to parent");
                        e.printStackTrace(System.out);
                        if (remoteExecutor == null) break block35;
                        remoteExecutor.close();
                        remoteExecutor = null;
                    }
                }
                if (remoteExecutor != null) {
                    try {
                        Class<?> applicationClass = Class.forName(applicationClassName);
                        String[] realArguments = new String[arguments.length - 1];
                        for (int i = 1; i < arguments.length; ++i) {
                            realArguments[i - 1] = arguments[i];
                        }
                        Method mainMethod = applicationClass.getMethod("main", String[].class);
                        mainMethod.invoke(null, new Object[]{realArguments});
                    }
                    catch (ClassNotFoundException e) {
                        System.out.println("JavaApplicationLauncher: Could not load the class " + applicationClassName);
                        e.printStackTrace(System.out);
                    }
                    catch (NoSuchMethodException e) {
                        System.out.println("JavaApplicationLauncher: Could not locate a main method for " + applicationClassName);
                        e.printStackTrace(System.out);
                    }
                    catch (IllegalAccessException e) {
                        System.out.println("JavaApplicationLauncher: Could not access the main method for " + applicationClassName);
                        e.printStackTrace(System.out);
                    }
                    catch (InvocationTargetException e) {
                        System.out.println("JavaApplicationLauncher: Failed to invoke the main method for " + applicationClassName);
                        e.printStackTrace(System.out);
                    }
                    finally {
                        isTerminating.set(true);
                        try {
                            remoteExecutor.close();
                        }
                        catch (Exception e) {}
                    }
                }
            }
        }
    }
}

