/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.runtime.java;

import com.oracle.tools.runtime.AbstractPlatform;
import com.oracle.tools.runtime.Application;
import com.oracle.tools.runtime.ApplicationBuilder;
import com.oracle.tools.runtime.LocalPlatform;
import com.oracle.tools.runtime.java.ContainerBasedJavaApplicationBuilder;
import com.oracle.tools.runtime.java.JavaApplication;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;

public class JavaVirtualMachine
extends AbstractPlatform {
    private static JavaVirtualMachine INSTANCE = new JavaVirtualMachine();
    private boolean isAutoDebugEnabled = true;

    private JavaVirtualMachine() {
        super("JVM");
    }

    @Override
    public InetAddress getPublicInetAddress() {
        return LocalPlatform.getInstance().getPrivateInetAddress();
    }

    @Override
    public <A extends Application, B extends ApplicationBuilder<A>> B getApplicationBuilder(Class<A> applicationClass) {
        if (JavaApplication.class.isAssignableFrom(applicationClass)) {
            return (B)new ContainerBasedJavaApplicationBuilder();
        }
        return null;
    }

    public boolean isRunningWithDebugger() {
        try {
            return this.getRuntimeMXBean().getInputArguments().toString().indexOf("-agentlib:jdwp") > 0;
        }
        catch (Throwable t) {
            System.err.println("Error trying to determine debug status - " + t.getMessage());
            return false;
        }
    }

    public RuntimeMXBean getRuntimeMXBean() {
        return ManagementFactory.getRuntimeMXBean();
    }

    public void setAutoDebugEnabled(boolean enabled) {
        this.isAutoDebugEnabled = enabled;
    }

    public boolean getAutoDebugEnabled() {
        return this.isAutoDebugEnabled;
    }

    public boolean shouldEnableRemoteDebugging() {
        return this.getAutoDebugEnabled() && this.isRunningWithDebugger();
    }

    public static JavaVirtualMachine getInstance() {
        return INSTANCE;
    }
}

